trun.q               package:gamlss.tr               R Documentation

_T_r_u_n_c_a_t_e_d _I_n_v_e_r_s_e _C_u_m_u_l_a_t_i_v_e _D_e_n_s_i_t_y _F_u_n_c_t_i_o_n _o_f _a _g_a_m_l_s_s._f_a_m_i_l_y _D_i_s_t_r_i_b_u_t_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     Creates a function to produce the inverse of a truncated
     cumulative density function generated from a current GAMLSS family
     distribution

_U_s_a_g_e:

     trun.q(par, family = "NO", type = c("left", "right", "both"), ...)

_A_r_g_u_m_e_n_t_s:

     par: a vector with one (for 'left' or 'right' truncation) or two
          elements for 'both'  

  family: a 'gamlss.family' object, which is used to define the
          distribution and the link functions of the various
          parameters.  The distribution families supported by
          'gamlss()' can be found in 'gamlss.family'. Functions such as
          BI() (binomial) produce a family object. 

    type: whether 'left', 'right' or in 'both' sides truncation is
          required, (left is the default)  

     ...: for extra arguments 

_V_a_l_u_e:

     Returns a q family function

_A_u_t_h_o_r(_s):

     Mikis Stasinopoulos d.stasinopoulos@londonmet.ac.uk and Bob Rigby
     r.rigby@londonmet.ac.uk

_R_e_f_e_r_e_n_c_e_s:

     Rigby, R. A. and  Stasinopoulos D. M. (2005). Generalized additive
     models for location, scale and shape,(with discussion),  _Appl.
     Statist._, *54*, part 3, pp 507-554.

     Stasinopoulos D. M., Rigby R.A. and Akantziliotou C. (2003)
     Instructions on how to use the GAMLSS package in R. Accompanying
     documentation in the current GAMLSS  help files, (see also  <URL:
     http://www.gamlss.com/>).

_S_e_e _A_l_s_o:

     'trun.d', 'trun.q', 'trun.r', 'gen.trun'

_E_x_a_m_p_l_e_s:

     # continuous
     #----------------------------------------------------------------------------------------
     # left
     test1<-trun.q(par=c(0), family="TF", type="left")
     test1(.6)
     qTF(pTF(0)+0.6*(1-pTF(0)))
     #----------------------------------------------------------------------------------------
     # right
     test2 <- trun.q(par=c(10), family="BCT", type="right")
     test2(.6)
     qBCT(0.6*pBCT(10))
     #----------------------------------------------------------------------------------------
     # both
     test3<-trun.q(par=c(-3,3), family="TF", type="both")
     test3(.6)
     qTF(0.6*(pTF(3)-pTF(-3))+pTF(-3))
     #----------------------------------------------------------------------------------------
     #----------------------------------------------------------------------------------------
     # FOR DISCRETE DISTRIBUTIONS
     # trucated q function
     # left
     test4<-trun.q(par=c(0), family="PO", type="left")
     test4(.6)
     qPO(pPO(0)+0.6*(1-pPO(0)))
     #----------------------------------------------------------------------------------------
     # right
     test5 <- trun.q(par=c(10), family="NBI", type="right")
     test5(.6)
     qNBI(0.6*pNBI(10))
     test5(.6, mu=10, sigma=2)
     qNBI(0.6*pNBI(10, mu=10, sigma=2), mu=10, sigma=2)
     #----------------------------------------------------------------------------------------
     # both
     test6<-trun.q(par=c(0,10), family="NBI", type="both")
     test6(.6)
     qNBI(0.6*(pNBI(10)-pNBI(0))+pNBI(0))
     #----------------------------------------------------------------------------------------

