trun.r               package:gamlss.tr               R Documentation

_G_e_n_e_r_a_t_e_s _R_a_n_d_o_m _V_a_l_u_e_s _f_r_o_m _a _T_r_u_n_c_a_t_e_d _D_e_n_s_i_t_y _F_u_n_c_t_i_o_n _o_f _a _g_a_m_l_s_s._f_a_m_i_l_y _D_i_s_t_r_i_b_u_t_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     Creates a function to generate randon values from a truncated
     probability density function created from a current GAMLSS family
     distribution

_U_s_a_g_e:

     trun.r(par, family = "NO", type = c("left", "right", "both"), ...)

_A_r_g_u_m_e_n_t_s:

     par: a vector with one (for 'left' or 'right' truncation) or two
          elements for 'both'  

  family: a 'gamlss.family' object, which is used to define the
          distribution and the link functions of the various
          parameters.  The distribution families supported by
          'gamlss()' can be found in 'gamlss.family'. Functions such as
          BI() (binomial) produce a family object. 

    type: whether 'left', 'right' or in 'both' sides truncation is
          required, (left is the default)  

     ...: for extra arguments 

_V_a_l_u_e:

     Returns a r family function

_A_u_t_h_o_r(_s):

     Mikis Stasinopoulos d.stasinopoulos@londonmet.ac.uk and Bob Rigby
     r.rigby@londonmet.ac.uk

_R_e_f_e_r_e_n_c_e_s:

     Rigby, R. A. and  Stasinopoulos D. M. (2005). Generalized additive
     models for location, scale and shape,(with discussion),  _Appl.
     Statist._, *54*, part 3, pp 507-554.

     Stasinopoulos D. M., Rigby R.A. and Akantziliotou C. (2003)
     Instructions on how to use the GAMLSS package in R. Accompanying
     documentation in the current GAMLSS  help files, (see also  <URL:
     http://www.gamlss.com/>).

_S_e_e _A_l_s_o:

     'trun.p', 'trun.q', 'trun.d', 'gen.trun'

_E_x_a_m_p_l_e_s:

     # trucated r function
     # continuous
     #----------------------------------------------------------------------------------------
     # left
     test1<-trun.r(par=c(0), family="TF", type="left")
     rr<-test1(1000)
     hist(rr)
     #----------------------------------------------------------------------------------------
     # right
     test2 <- trun.r(par=c(10), family="BCT", type="right")
     rr<-test2(1000)
     hist(rr)
     #----------------------------------------------------------------------------------------
     # both
     test3<-trun.r(par=c(-3,3), family="TF", type="both")
     rr<-test3(1000)
     hist(rr)
     #----------------------------------------------------------------------------------------
     # discrete 
     # trucated r function
     # left
     test1<-trun.r(par=c(0), family="PO", type="left")
     tN <- table(Ni <- test1(1000))
      r <- barplot(tN, col='lightblue')
     #----------------------------------------------------------------------------------------
     # right
     test2 <- trun.r(par=c(10), family="NBI", type="right")
     tN <- table(Ni <- test2(1000))
      r <- barplot(tN, col='lightblue')
     tN <- table(Ni <- test2(1000,mu=5))
       r <- barplot(tN, col='lightblue')
     tN <- table(Ni <- test2(1000,mu=10, sigma=.1))
       r <- barplot(tN, col='lightblue')
     #----------------------------------------------------------------------------------------
     # both 
     test3<-trun.r(par=c(0,10), family="NBI", type="both")
      tN <- table(Ni <- test3(1000,mu=5))
      r <- barplot(tN, col='lightblue')

