### Name: GMRF
### Title: Gaussian Markov random fields
### Aliases: GMRF momentsGMRF rGMRF dGMRF dGMRF2
### Keywords: distribution multivariate

### ** Examples

set.seed(1977)

mu <- c(0, 6, 8)
L <- matrix(1:9, nrow=3)
L[upper.tri(L, diag=FALSE)] <- 0
Sigma <- L %*% t(L)
Q <- chol2inv(chol(Sigma))

A <- rep(1, nrow(Sigma))
b <- 0

##### Unconstrained GMRF
##### ==================
## Moments
momentsGMRF(mean=mu, Sigma=Sigma)
momentsGMRF(mean=mu, Q=Q)

## Random numbers
z <- rGMRF(1000, mean=mu, Sigma=Sigma)
apply(z$x, 2, mean)
var(z$x)

## Random numbers, again
z <- rGMRF(10, mean=mu, Sigma=Sigma)
print(z)

## Values of the log-density
dGMRF(z$x, mean=mu, Sigma=Sigma, log=TRUE)
dGMRF(z$x, mean=mu, Q=Q, log=TRUE)
dGMRF2(z$x, mean=mu, Sigma=Sigma, log=TRUE)
dGMRF2(z$x, mean=mu, Q=Q, log=TRUE)

## Values of the density
dGMRF(z$x, mean=mu, Sigma=Sigma)
dGMRF(z$x, mean=mu, Q=Q)
dGMRF2(z$x, mean=mu, Sigma=Sigma)
dGMRF2(z$x, mean=mu, Q=Q)

##### Constrained GMRF
##### ================
## Moments
momentsGMRF(mean=mu, Sigma=Sigma, A=A, b=b)
momentsGMRF(mean=mu, Q=Q, A=A, b=b)

## Random numbers
z <- rGMRF(1000, mean=mu, Sigma=Sigma, A=A, b=b)
apply(z$x, 2, mean)
var(z$x)

## Random numbers, again
z <- rGMRF(10, mean=mu, Sigma=Sigma, A=A, b=b)
print(z)
A %*% t(z$x)

## Values of the log-density
dGMRF(z$x, mean=mu, Sigma=Sigma, A=A, b=b, log=TRUE)
dGMRF(z$x, mean=mu, Q=Q, A=A, b=b, log=TRUE)
dGMRF2(z$x, mean=mu, Sigma=Sigma, A=A, b=b, log=TRUE)
dGMRF2(z$x, mean=mu, Q=Q, A=A, b=b, log=TRUE)

## Values of the log-density
dGMRF(z$x, mean=mu, Sigma=Sigma, A=A, b=b)
dGMRF(z$x, mean=mu, Q=Q, A=A, b=b)
dGMRF2(z$x, mean=mu, Sigma=Sigma, A=A, b=b)
dGMRF2(z$x, mean=mu, Q=Q, A=A, b=b)



