### Name: QuantileFun
### Title: Sample quantiles
### Aliases: QuantileFun
### Keywords: univar

### ** Examples

probs <- c(0, 0.25, 0.354, 0.5, 0.75, 1)

x <- rnorm(1001)
QuantileFun(x, probs=probs)
quantile(x, probs=probs)

n <- 1001
xx <- data.frame(x1=rnorm(n), x2=rgamma(n, shape=1, rate=1), x3=1:n)
QuantileFun(xx, probs=probs, vals.in.cols=TRUE)
apply(xx, 2, quantile, probs=probs)

xx2 <- t(xx)
QuantileFun(xx2, probs=probs, vals.in.cols=FALSE)
apply(xx2, 1, quantile, probs=probs)



