### Name: cumlogit
### Title: Cumulative logit model for ordinal responses
### Aliases: cumlogit print.cumlogit summary.cumlogit
### Keywords: models

### ** Examples

## Simulate the data for C = 3
## ============================
set.seed(775988621)
N3 <- 1000

  ## covariates:
x3 <- data.frame(x1=rnorm(N3), x2=runif(N3, 0, 1))
v3 <- data.frame(v1=rnorm(N3), v2=runif(N3, 0, 1))

  ## regression coefficients
  ## (theta = c(0.1, -0.2,   1, 0.1, -0.2,   0, 0.05, -0.25,   -0.5, 0.05, -0.25)):
alpha3 <- c(1, 0, -0.5)     
beta3 <- c(0.1, -0.2)
gamma3 <- list(c(0.1, -0.2), c(0.05, -0.25), c(0.05, -0.25))

 ## linear predictors and inverse logits:
eta3 <- data.frame(eta1=alpha3[1] + as.matrix(x3) %*% beta3 +
                        as.matrix(v3) %*% gamma3[[1]],
                   eta2=alpha3[2] + as.matrix(x3) %*% beta3 +
                        as.matrix(v3) %*% gamma3[[2]],
                   eta3=alpha3[3] + as.matrix(x3) %*% beta3 +
                        as.matrix(v3) %*% gamma3[[3]])                    
ilogit3 <- data.frame(ilogit1 = exp(eta3[,1])/(1 + exp(eta3[,1])),
                      ilogit2=exp(eta3[,2])/(1 + exp(eta3[,2])),
                      ilogit3=exp(eta3[,3])/(1 + exp(eta3[,3])))                         

 ## category probabilities:
pis3 <- data.frame(pi0=1-ilogit3[,1],
                   pi1=ilogit3[,1]-ilogit3[,2],
                   pi2=ilogit3[,2]-ilogit3[,3],
                   pi3=ilogit3[,3])

 ## response:
rtemp <- function(prob, C){
  return(sample(0:C, size=1, prob=prob))
}
y3 <- apply(pis3, 1, rtemp, C=3)

## Fit the model
## ===============
fit <- cumlogit(y=y3, x=x3, v=v3, C=3)
print(fit)

fit2 <- cumlogit(y=y3, x=x3, v=v3, C=3, logit.order="increasing")
print(fit2)



