### Name: gspline1
### Title: Density and random number generation from a univariate G-spline
###   (penalized Gaussian mixture)
### Aliases: gspline1 dgspline1 rgspline1
### Keywords: smooth

### ** Examples

knots <- c(-2, 0, 2)
sigma <- 1
weight <- c(0.3, 0.1, 0.6)
intcpt <- 3
scale <- 0.2
xgrid <- seq(1.8, 4.2, length=300)

dx <- dgspline1(xgrid, mu=knots, sigma=sigma, weight=weight,
   intcpt=intcpt, scale=scale, logw=FALSE)
x <- rgspline1(100, mu=knots, sigma=sigma, weight=weight,
   intcpt=intcpt, scale=scale, logw=FALSE)
hist(x, col="seagreen2", prob=TRUE, xlim=range(xgrid), xlab="x", ylab="g(x)")
lines(xgrid, dx, col="red", lwd=2)



