### Name: gspline2
### Title: Density and random number generation from a bivariate G-spline
###   (penalized Gaussian mixture)
### Aliases: gspline2 rgspline2
### Keywords: smooth

### ** Examples

knots1 <- c(-2, 0, 2)
knots2 <- c(-2, -1, 0, 1, 2)
sigma1 <- 0.5
sigma2 <- 0.5
intcpt <- c(3, -1)
scale <- c(0.2, 0.5)

weight <- matrix(c(1,2,1,  2,3,2,  3,4,3,  2,3,2,  1,2,1), ncol=5)
xA <- rgspline2(1000, mu1=knots1, mu2=knots2, sigma1=sigma1,
   sigma2=sigma2, weight=weight, intcpt=intcpt, scale=scale, logw=FALSE)
xB <- rgspline2(1000, mu1=knots1, mu2=knots2, sigma1=sigma1,
   sigma2=sigma2, weight=log(weight), intcpt=intcpt, scale=scale, logw=TRUE)

oldpar <- par(mfrow=c(1, 2), bty="n")
plot(xA[,2], xA[,1], pch=16, col="red")
abline(h=intcpt[1]+scale[1]*knots1, col="orange")
abline(v=intcpt[2]+scale[2]*knots2, col="orange")
plot(xB[,2], xB[,1], pch=16, col="blue")
abline(h=intcpt[1]+scale[1]*knots1, col="orange")
abline(v=intcpt[2]+scale[2]*knots2, col="orange")
par(oldpar)

### Only selected components with non-zero weights
logweight2 <- c(-1, -0.5, 1)
knotInd <- c(0, 5, 14)
yA <- rgspline2(1000, mu1=knots1, mu2=knots2, sigma1=sigma1,
   sigma2=sigma2, weight=logweight2, knotInd=knotInd,
   intcpt=intcpt, scale=scale, logw=TRUE)
yB <- rgspline2(1000, mu1=knots1, mu2=knots2, sigma1=sigma1,
   sigma2=sigma2, weight=exp(logweight2), knotInd=knotInd,
   intcpt=intcpt, scale=scale, logw=FALSE)
oldpar <- par(mfrow=c(1, 2), bty="n")
plot(yA[,2], yA[,1], pch=16, col="red")
abline(h=intcpt[1]+scale[1]*knots1, col="orange")
abline(v=intcpt[2]+scale[2]*knots2, col="orange")
plot(yB[,2], yB[,1], pch=16, col="blue")
abline(h=intcpt[1]+scale[1]*knots1, col="orange")
abline(v=intcpt[2]+scale[2]*knots2, col="orange")
par(oldpar)

logweight3 <- log(weight)[-c(5,8,11)]
knotInd3 <- c(0,1,2, 3,5, 6,8, 9,11, 12,13,14)
zA <- rgspline2(1000, mu1=knots1, mu2=knots2, sigma1=sigma1,
   sigma2=sigma2, weight=logweight3, knotInd=knotInd3,
   intcpt=intcpt, scale=scale, logw=TRUE)
zB <- rgspline2(1000, mu1=knots1, mu2=knots2, sigma1=sigma1,
   sigma2=sigma2, weight=exp(logweight3), knotInd=knotInd3,
   intcpt=intcpt, scale=scale, logw=FALSE)
oldpar <- par(mfrow=c(1, 2), bty="n")
plot(zA[,2], zA[,1], pch=16, col="red")
abline(h=intcpt[1]+scale[1]*knots1, col="orange")
abline(v=intcpt[2]+scale[2]*knots2, col="orange")
plot(zB[,2], zB[,1], pch=16, col="blue")
abline(h=intcpt[1]+scale[1]*knots1, col="orange")
abline(v=intcpt[2]+scale[2]*knots2, col="orange")
par(oldpar)



