### Name: logpoisson
### Title: Poisson log-linear regression model
### Aliases: logpoisson print.logpoisson summary.logpoisson
### Keywords: models

### ** Examples

set.seed(1977)
n <- 100
x1 <- rbinom(n, 1, 0.4)
x2 <- runif(n, 0, 1)
eta <- 5 + 0.1*x1 -0.2*x2
mu <-  exp(eta)
y <- rpois(n, mu)

### Fit the model using poisson
Xmat <- data.frame(x1=x1, x2=x2)
fit <- logpoisson(y=y, x=Xmat)
summary(fit)

### Fit the model using standard glm
fit0 <- glm(y~x1+x2, family=poisson(link="log"))
summary(fit0)



