### Name: maxPosterProb
### Title: G-spline utility
### Aliases: maxPosterProb
### Keywords: models

### ** Examples

  N <- 100
  intcpt <- c(0, 5, 15)
  std.dev <- c(1, 0.5, 3)
  data <- data.frame(b1=rnorm(N, intcpt[1], std.dev[1]),
                     b2=rnorm(N, intcpt[2], std.dev[2]),
                     b3=rnorm(N, intcpt[3], std.dev[3]))
  alloc <- maxPosterProb(data=data, intercept=intcpt, std.dev=std.dev,
                         K=15, delta=0.3, sigma=0.2)

  par(mfrow=c(1, 3), bty="n")
  for (i in 1:3) hist(alloc[,i], prob=TRUE, col="seagreen3",
                      xlab="Allocation", breaks=(-15):15,
                      main=paste("Margin ", i, sep=""))



