### Name: haplo.ccs
### Title: Estimate Haplotype Relative Risks in Case-Control Data
### Aliases: haplo.ccs haplo.ccs.fit summary.haplo.ccs print.haplo.ccs
###   print.summary.haplo.ccs coef.haplo.ccs fitted.haplo.ccs
###   residuals.haplo.ccs vcov.haplo.ccs haplo.freq anova.haplo.ccs
###   logLik.haplo.ccs AIC.haplo.ccs one count.haps return.haps
### Keywords: models regression

### ** Examples


data(renin)

## Fit a model for haplotype effects.

haplo.ccs(case ~ haplo(geno))

## Fit a model for haplotype and covariate effects.

haplo.ccs(case ~ gender + age + factor(race) + haplo(geno))

## Fit a model for haplotype interaction with gender.

haplo.ccs(case ~ age + factor(race) + gender*haplo(geno))




