### Name: sp
### Title: Calculate the conditional state probabilities.
### Aliases: sp
### Keywords: models

### ** Examples

P <- matrix(c(0.7,0.3,0.1,0.9),2,2,byrow=TRUE)
R <- matrix(c(0.5,0,0.1,0.1,0.3,
              0.1,0.1,0,0.3,0.5),5,2)
set.seed(42)
y.num   <- sim.hmm(rep(300,20),P,R)
fit.num <- hmm(y.num,K=2,verb=TRUE)
cpe1    <- sp(object=fit.num,means=TRUE)    # Using the estimated parameters.
cpe2    <- sp(y.num,tpm=P,Rho=R,means=TRUE) # Using the ``true'' parameters.



