### Name: bernoulli
### Title: Hyperdirichlet distributions for various types of informative
###   trials
### Aliases: bernoulli bernoulli_obs mult_restricted_obs obs
###   single_bernoulli_obs mult_bernoulli_obs single_multi_restricted_obs
###   single_obs


### ** Examples

# Five players, some results:

jj1 <- obs(1:5)                             # five players, player 'i' wins 'i' games.
jj2 <- single_obs(5,2)                      # open game, p2 wins
jj3 <- single_multi_restricted_obs(5,2,1:3) # match: 1,2,3; p2 wins
jj4 <- mult_restricted_obs(5,1:2,c(0,4))    # match: 1,2, p1 wins 2 games, p2 wins 3
jj5 <- single_bernoulli_obs(5,1:2,3:5)      # match: 1&2 vs 3&4&5; 1&2 win
jj6 <- mult_bernoulli_obs(6, 1:2,c(3,5), 7,8) # match: 1&2 vs 3&5; 1&2 win 7, 3&5 win 8
jj6 <- bernoulli_obs(5,list(1:2,1:2), list(3,3:5)) # 1&2 beat 3; 1&2 beat 3&4&5

# Now imagine that jj1-jj6 are independent observations:

ans <- jj1 + jj2 + jj3 + jj4 + jj5 + jj6  #posterior PDF with uniform prior likelihood




