### Name: hyperdirichlet
### Title: The Hyperdirichlet distribution
### Aliases: hyperdirichlet as.hyperdirichlet is.hyperdirichlet
###   as.hyperdirichlet,hyperdirichlet-method
###   as.hyperdirichlet,numeric-method as.hyperdirichlet,matrix-method
###   is.hyperdirichlet,hyperdirichlet-method


### ** Examples


(a <- uniform(3))
a[c(TRUE,TRUE,FALSE)] <- 0.3
## Not run: 
##D (a <- as.hyperdirichlet(a, calculate_NC = TRUE))  # recommended way to calculate NC
## End(Not run)

(b <- dirichlet(1:3))
as.hyperdirichlet(b)          # "forgets" the normalizing constant

## Not run: 
##D as.hyperdirichlet(b, TRUE)    # recalculates NC; accuracy tolerable
##D                               # (analytic answer = 1/60)
## End(Not run)

## Not run: 
##D   # takes a long time
##D op <- options()
##D options(warn = -1)
##D x <- dirichlet(rep(2,4)) + justpairs(matrix(1,4,4))
##D f <- function(p){p[1]>p[2]}
##D probability(x,f) # should be 0.5: distribution is symmetric
## End(Not run)




