### Name: serum
### Title: Serum data from Mosimann 1962
### Aliases: serum
### Keywords: datasets

### ** Examples

data(serum)
dhyperdirichlet(serum , HD=dirichlet(4:6),log=TRUE)

f <- function(x){
  if(any(x<0)){
    return(Inf)
  } else {
    return(-sum(dhyperdirichlet(serum , HD=dirichlet(x),include.NC=TRUE,log=TRUE)))
  }
}

fish <- optim(c(3.21,20.38,21.68),f)
triplot(HD=dirichlet(fish$par),l=60,main="increase 'l' for better plot quality")
points(serum[,1]+serum[,2]/2,serum[,2]*sqrt(3)/2,pch=16)




