### Name: learn.graph
### Title: Graph learning functions
### Aliases: learn.complex.norm learn.complex.multinom learn.mec.norm
###   learn.mec.multinom learn.skeleton.norm learn.skeleton.multinom
###   learn.v
### Keywords: graphs multivariate models

### ** Examples

set.seed(100)
p.value <- .01
n <- 3000
is.chaingraph(toy.graph)
tgdata <- rnorm.cg(n, toy.graph, get.normal.dist(toy.graph))
tgug <- naive.getug.norm(tgdata, p.value)
tg.jtree <- ug.to.jtree(tgug)
tg.pat <- learn.mec.norm(tg.jtree, cov(tgdata), n, p.value, "CG")
comp.skel(skeleton(toy.graph), skeleton(tg.pat))
comp.pat(pattern(toy.graph), tg.pat)



