### Name: Nemaspec
### Title: Nematode species composition of 6 deep-sea sediments in the
###   Mediterranean
### Aliases: Nemaspec
### Keywords: datasets

### ** Examples
head(Nemaspec)
# select densities of species present in M160b
st160b<-data.frame(Nemaspec$SPECIES,dens=Nemaspec$M160b)
st160b<-st160b[st160b$dens!=0,]

plot(cumsum(rev(sort(st160b$dens)/sum(st160b$dens))),
     main="dominance curve",
     xlab="species rank",ylab="cum freq")



