### Name: Zoogrowth
### Title: a zooplankton growth dataset
### Aliases: Zoogrowth
### Keywords: datasets

### ** Examples

plot(Zoogrowth$Volume,Zoogrowth$Mumax,log="xy",
      xlab="zooplankton volume, micrometer ^ 3",
      ylab="maximal growth rate, /hr",main="Zoogrowth",cex=2,
      pch=(15:20)[Zoogrowth$Group],col=(1:6)[Zoogrowth$Group])
legend("topright",legend=levels(Zoogrowth$Group),col=1:6,pch=15:20)

ll <- lm(log(Zoogrowth[,2])~ log(Zoogrowth[,1]))
rr <- summary(ll)$r.squared
A  <- exp(coef(ll)[1])
B  <- (coef(ll)[2])
curve(A*x^B,add=TRUE,lwd=2)
AA <- round(A*100)/100
BB <- round(B*100)/100
expr <- substitute(y==A*x^B,list(A=AA,B=BB))
text(100,.0035,expr,adj=0)
expr2 <- substitute(r^2==rr,list(rr=round(rr*100)/100))
text(100,0.002,expr2, adj=0)


