###################################################
### chunk number 1: preliminaries
###################################################
library("deSolve")
library("rootSolve")
library("scatterplot3d")
library("seacarb")
library("marelac")
library("marelacTeaching")
options(prompt = "> ")
options(width = 70)



###################################################
### chunk number 2: 
###################################################
(4/6*8-1)^(2/3)
log(20)
log2(4096)
2*pi*3
exp(2+cos(0.5*pi))

# length of 3rd side of a triangle with size 2.3 and 5.4 and angle  pi/8
sqrt(2.3^2+5.4^2-2*2.3*5.4*cos(pi/8))  


###################################################
### chunk number 3: 
###################################################
mean(c(9,17))


###################################################
### chunk number 4: 
###################################################
(V<-seq(16,56,by=2)) # creates AND displays the vector
# or:
V <- 16+2*(0:20)  ; V
sum(V)
V[1:4]
prod(V[1:4])
V[c(4,9,11)]


###################################################
### chunk number 5: 
###################################################
W<-V*3; W
W100<-W[W<100] ; length(W100)
# or
length(W[W<100])


###################################################
### chunk number 6: 
###################################################
1/1:10
sqrt(1/1:10)
(1/1:10)^2
(0:9)/(1:10)    # or : 0:9/1:10


###################################################
### chunk number 7: 
###################################################
U <- runif(100,-1,1)
range(U)
sum(U);prod(U)
length(U[U>0]) # or: sum(U>0)
U[U<0]<-0
sort(U)


###################################################
### chunk number 8: 
###################################################
x<- c(2,9,0,2,7,4,0)
y<- c(3,5,0,2,5,4,6)
y/x
x>y
x==0
y[y>x]
y[x==0]
y<-y[x!=0]
x[x>=7]<-0 ; x


###################################################
### chunk number 9: 
###################################################
A<-matrix(nrow=2,data=c(3,7,9,4)) ; A
A<-matrix(nrow=3,data=1/1:9,byrow=TRUE)  # or: 1/matrix(nrow=3,data=1:9,byrow=TRUE)
t(A)
B <- A[1:2,1:2] ; B


###################################################
### chunk number 10: 
###################################################
D   <- diag(nrow=3,c(1,2,3))

DD  <- cbind(D,rep(4,3))  # or: cbind(D,4)
DDD <- rbind(DD,rep(5,4)) # or: rbind(DD,5)
DDD
# same, in one sentence
DD <- rbind(cbind(D,4),5)

DD[-2,-2]


###################################################
### chunk number 11: 
###################################################
head(Nemaspec)

dens <- Nemaspec[,2]
dens <- dens[dens>0]
N    <- sum(dens);
p    <- dens/N
N0   <- length(p)
N1   <- exp(sum(-p*log(p)))
N2   <- sum(p*p)^(-1)
Ni   <- 1/max(p)
ESS  <- N0-1/choose(N,100)*sum(choose(n=(N-dens),k=100))

c(N=N,N0=N0,N1=N1,N2=N2,Ni=Ni,ESS=ESS)


###################################################
### chunk number 12: 
###################################################
## Sphere function
Sphere <- function(radius)
{
 vol   <- 4/3*pi*radius^3
 surf  <- 4 *pi*radius^2
 circ  <- 2*pi*radius
 return(list(volume=vol,surface=surf,circumference=circ))
}
Sphere(6371)


###################################################
### chunk number 13: 
###################################################
SatOx <- function(T=20,S=35)
  {
    T <- T+273.15
    A= -173.9894 + 25559.07/T + 146.4813* log(T/100) -22.204*T/100 + S *
      (-0.037362+0.016504*T/100-0.0020564 *T/100*T/100)
    exp(A)
  }
SatOx()
SatOx(0:30)


###################################################
### chunk number 14: 
###################################################
Fibo<-vector()
Fibo[1:2]<-1
for (i in 3:50) Fibo[i]<-Fibo[i-1]+Fibo[i-2]
(1+sqrt(5))/2
Fibo[50]/Fibo[49]
Fibo[2:50]/Fibo[1:49]- (1+sqrt(5))/2


###################################################
### chunk number 15: 
###################################################
Diversity <- function (Dens,   # density, each column a station
                       S=100)  # common number of individuals on which
                               # to estimate expected number of species
{

  nstat <- NCOL(Dens)                            # number of stations
  if(is.vector(Dens)) Dens <- matrix(ncol=nstat,Dens)
  div   <- matrix(nrow=nstat,ncol=6,data=NA)     # create matrix for results
  rownames(div) <- colnames(Dens)
  colnames(div) <- c("N","N0","N1","N2","Ninf",paste("ESS",S,sep=""))

  for (i in 1:nstat)
   {
     dens<- Dens[,i]
     dens<- dens[dens>0]  # selection of species present
     N   <- sum(dens)     # N, total density
     p   <- dens/N        # relative proportion
     N0  <- length(p)     # N0 = number of species present
     N1  <- exp(sum(-p*log(p)))   # N1 = exp(Shannon-Wiener)
     N2  <- sum(p*p)^(-1)         # Na = sum(sp^a)^(1/(1-a)
     Ni  <- 1/max(p)               # Ninf
     ESS <- N0-1/choose(N,S)*sum(choose(n=(N-dens),k=S))
     div[i,] <- c(N,N0,N1,N2,Ni,ESS)
   }
  return(div)
}

summary(Nemaspec)                  # calculate summary characteristics

# remove species names
(divspec<-Diversity(Nemaspec[,-1]))


###################################################
### chunk number 16: 
###################################################
dens <- Nemaspec[,2]
dens <- dens[dens>0]  # selection of species present
cs   <- round(dens)  # rarefaction method can only work with integer numbers
ind  <- NULL         # individual organisms; each one belonging to a species
for (i in 1:length(cs)) ind <- c(ind,rep(i,times=cs[i]))

ind100 <-sample(ind,size=100)      # take 100 random individuals
Spec   <-table(ind100)             # table of counts: speciesnr versus nr ind
ESS100 <-length(Spec)              # length of Spec = number of species

# or, three sentences combined in 1!
length(table(sample(ind,size=100)))

ESS100 <- vector()
for (i in 1:1000) ESS100[i] <- length(table(sample(ind,size=100)))
mean (ESS100)


###################################################
### chunk number 17: stat
###################################################
nemaspec <- Nemaspec[,-1]
hc <- hclust(dist(t(nemaspec)), "ave")
par(mfrow=c(2,2))
plot(hc)
plot(hc, hang = -1)

x <- prcomp(t(nemaspec))
biplot(x)

x2 <- prcomp(t(nemaspec[,-(1:2)]))
biplot(x2)
par(mfrow=c(1,1))


###################################################
### chunk number 18: figstat
###################################################
nemaspec <- Nemaspec[,-1]
hc <- hclust(dist(t(nemaspec)), "ave")
par(mfrow=c(2,2))
plot(hc)
plot(hc, hang = -1)

x <- prcomp(t(nemaspec))
biplot(x)

x2 <- prcomp(t(nemaspec[,-(1:2)]))
biplot(x2)
par(mfrow=c(1,1))


###################################################
### chunk number 19: graph
###################################################
par(mfrow=c(2,2))
# simple curves
curve(x^3*sin(3*pi*x)^2,-2,2)
curve(1/cos(1+x^2),-5,5)
# ammonia
pN <- function(pH,Kn=8*10^-10) Kn/(Kn+10^-pH)
curve(pN(x),4,9,main="fraction toxic ammonium")
curve(pN(x,Kn=8*10^-11),4,9,add=TRUE,col="red")
legend("topleft",lty=1,col=c("black","red"),c("30 dg","0 dg"))

# US population
K  <- 500
N0 <- 76.1
a  <- 0.02
curve(K/(1+((K-N0)/N0*exp(-a*(x-1900)))),1900,1980,main="US population",
      xlab="year",ylab= "million",lwd=2)
N <- matrix(ncol=2,data=c(
seq(1900,1980,by=10), 76.1,92.4,106.5,123.1,132.6,152.3,180.7,204.9,226.5
                         )  )
points(N)


###################################################
### chunk number 20: figgraph
###################################################
par(mfrow=c(2,2))
# simple curves
curve(x^3*sin(3*pi*x)^2,-2,2)
curve(1/cos(1+x^2),-5,5)
# ammonia
pN <- function(pH,Kn=8*10^-10) Kn/(Kn+10^-pH)
curve(pN(x),4,9,main="fraction toxic ammonium")
curve(pN(x,Kn=8*10^-11),4,9,add=TRUE,col="red")
legend("topleft",lty=1,col=c("black","red"),c("30 dg","0 dg"))

# US population
K  <- 500
N0 <- 76.1
a  <- 0.02
curve(K/(1+((K-N0)/N0*exp(-a*(x-1900)))),1900,1980,main="US population",
      xlab="year",ylab= "million",lwd=2)
N <- matrix(ncol=2,data=c(
seq(1900,1980,by=10), 76.1,92.4,106.5,123.1,132.6,152.3,180.7,204.9,226.5
                         )  )
points(N)


###################################################
### chunk number 21: 
###################################################
head(iris)
class(iris)
dim(iris)


###################################################
### chunk number 22: iris1
###################################################
par(mfrow=c(2,2))

plot(iris$Petal.Length,iris$Petal.Width,cex=1.5,pch=15,
      xlab="Petal length", ylab=" Petal width")
plot(iris$Petal.Length,iris$Petal.Width,cex=1.5,pch=15,
     xlab="Petal length", ylab=" Petal width",
     col=c("red","blue","green")[iris$Species])
legend("bottomright",pch=15,col=c("red","blue","green"),
     legend=levels(iris$Species))

boxplot(Petal.Width~Species,data=iris)


###################################################
### chunk number 23: iris1graph
###################################################
par(mfrow=c(2,2))

plot(iris$Petal.Length,iris$Petal.Width,cex=1.5,pch=15,
      xlab="Petal length", ylab=" Petal width")
plot(iris$Petal.Length,iris$Petal.Width,cex=1.5,pch=15,
     xlab="Petal length", ylab=" Petal width",
     col=c("red","blue","green")[iris$Species])
legend("bottomright",pch=15,col=c("red","blue","green"),
     legend=levels(iris$Species))

boxplot(Petal.Width~Species,data=iris)


###################################################
### chunk number 24: iris2
###################################################
par(mfrow=c(2,2))
boxplot(Sepal.Length~Species, data=iris,main="sepal length")
boxplot(Sepal.Width~Species, data=iris,main="sepal width")
boxplot(Petal.Length~Species, data=iris,main="petal length")
boxplot(Petal.Width~Species, data=iris,main="petal width")
mtext(outer=TRUE,side=3,line=-2,"Iris data set",cex=1.5)


###################################################
### chunk number 25: iris2graph
###################################################
par(mfrow=c(2,2))
boxplot(Sepal.Length~Species, data=iris,main="sepal length")
boxplot(Sepal.Width~Species, data=iris,main="sepal width")
boxplot(Petal.Length~Species, data=iris,main="petal length")
boxplot(Petal.Width~Species, data=iris,main="petal width")
mtext(outer=TRUE,side=3,line=-2,"Iris data set",cex=1.5)


###################################################
### chunk number 26: 
###################################################
A <- matrix(nrow=3, data=c(1,6,-2,2,4,1,3,1,-1))
B <- matrix(nrow=3, data=1:9)
solve(A); t(A)
A%*%B
eigen(A)
ee<-eigen(A)
A%*%ee$vectors[,1]
ee$values[1]*ee$vectors[,1]


###################################################
### chunk number 27: 
###################################################
A<- matrix (nrow=4,data=c(0,     0.9775,0,     0,
                          0.0043,0.9111,0.0736,0,
                          0.1132,0,     0.9534,0.0452,
                          0,0,0,0.9804))
eigen(A)
T <- A
T[1,] <- 0
N <- solve(diag(4)-T) ; N


###################################################
### chunk number 28: 
###################################################
A <- matrix(nrow=3,data=c(3,6,7,4,2,1,5,7,0))
B <- c(0,5,6)
x <- solve(A,B)
A %*% x - B


###################################################
### chunk number 29: 
###################################################
root<-uniroot(f=function(x) exp(x)-4*x^2,interval=c(0,1))


###################################################
### chunk number 30: root
###################################################
curve(exp(x)-4*x^2,0,1)
abline(h=0,lty=2)
points(root$root,0,pch=16,cex=2)


###################################################
### chunk number 31: rootgraph
###################################################
curve(exp(x)-4*x^2,0,1)
abline(h=0,lty=2)
points(root$root,0,pch=16,cex=2)


###################################################
### chunk number 32: 
###################################################
res<-vector()
for (x in 1:100)
 res[x]<-uniroot (f=function(y) y*(3+x)*(1+y)^4-1000,c(-1000,1000))$root


###################################################
### chunk number 33: root2
###################################################
plot(1:100,res)


###################################################
### chunk number 34: root2fig
###################################################
plot(1:100,res)


###################################################
### chunk number 35: 
###################################################
require(seacarb)
k1 <- K1(S=0,T=20,P=0)
k2 <- K2(S=0,T=20,P=0)
kh <- Kh(S=0,T=20,P=0)

nonlinfun <- function(pH,pco2=360,alk=2300e-6)
{
 H    <- 10^(-pH)
 CO2  <- pco2*kh
 HCO3 <- k1*CO2/H
 CO3  <- k2*HCO3/H
 return( HCO3+2*CO3-H*1.e6 - alk)
}

uniroot(nonlinfun,interval=c(2,12),pco2=360,alk=2300,tol=1e-30)
pHseq   <- vector()
pco2seq <-200:1250
for (i in 1:length(pco2seq))
    pHseq[i]<-uniroot(nonlinfun,interval=c(2,12),
                      pco2=pco2seq[i],alk=2300,tol=1e-30)$root
# max drop of pH
pHseq[length(pHseq)]


###################################################
### chunk number 36: pH
###################################################
plot(pco2seq,pHseq,type="l",lwd=2,main="Effect of pCO2 on pH")


###################################################
### chunk number 37: pHfig
###################################################
plot(pco2seq,pHseq,type="l",lwd=2,main="Effect of pCO2 on pH")


###################################################
### chunk number 38: Smooth
###################################################
t3    <- seq(3,24,by=3)
wind3 <- c(6,7,9,4,6,3,7,9)
plot(approx(t3,wind3,xout=3:24),type="b" ,xlab="time",ylab="wind speed")


###################################################
### chunk number 39: smoothfig
###################################################
t3    <- seq(3,24,by=3)
wind3 <- c(6,7,9,4,6,3,7,9)
plot(approx(t3,wind3,xout=3:24),type="b" ,xlab="time",ylab="wind speed")


###################################################
### chunk number 40: pp
###################################################
ll <- c(0.,1,10,20,40,80,120,160,300,480,700)
pp <- c(0.,1,3,4,6,8,10,11,10,9,8)
plot(ll,pp,xlab= expression("light, Einst"~ m^{-2}~s^{-1}),
     ylab="production",pch=15,cex=1.5)

fit<-nls(pp ~pmax*2*(1+b)*(ll/iopt)/
                         ((ll/iopt)^2+2*b*ll/iopt+1),
     start=c(pmax=max(pp),b=0.005,iopt=ll[which.max(pp)]))

summary(fit)

pars <- as.list(coef(fit))

with(pars,
 curve(pmax*2*(1+b)*(x/iopt)/((x/iopt)^2+2*b*x/iopt+1),
       add=TRUE,lwd=2)   )

title(expression (frac(pmax%*%2%*%(1+beta)%*%I/Iopt,
                 (I/Iopt)^2+2%*%beta%*%I/Iopt+1)),cex.main=0.8)


###################################################
### chunk number 41: ppfig
###################################################
ll <- c(0.,1,10,20,40,80,120,160,300,480,700)
pp <- c(0.,1,3,4,6,8,10,11,10,9,8)
plot(ll,pp,xlab= expression("light, Einst"~ m^{-2}~s^{-1}),
     ylab="production",pch=15,cex=1.5)

fit<-nls(pp ~pmax*2*(1+b)*(ll/iopt)/
                         ((ll/iopt)^2+2*b*ll/iopt+1),
     start=c(pmax=max(pp),b=0.005,iopt=ll[which.max(pp)]))

summary(fit)

pars <- as.list(coef(fit))

with(pars,
 curve(pmax*2*(1+b)*(x/iopt)/((x/iopt)^2+2*b*x/iopt+1),
       add=TRUE,lwd=2)   )

title(expression (frac(pmax%*%2%*%(1+beta)%*%I/Iopt,
                 (I/Iopt)^2+2%*%beta%*%I/Iopt+1)),cex.main=0.8)


###################################################
### chunk number 42: lotka
###################################################
require(deSolve)
model <- function (time,VAR,pars)
{
 with (as.list(c(VAR,pars)), {
  #  the rate of change of the state variables
  dx     <- a*x*(1-x/K)-b*x*y
  dy     <- g*b*x*y    - e*y

 return(list(c(dx,dy)))
                     })
}

pars  <- c(a=0.05,b=0.0002,K=500,g=0.8,e=0.03)
VAR   <- c(x=300,y=10)
times <- seq(0,1000,1)

out   <- as.data.frame(lsoda(VAR,times,model,pars))
plot(out$x,out$y,type="l")

VAR   <- c(x=200,y=50)
out2  <- as.data.frame(lsoda(VAR,times,model,pars))
lines(out2$x,out2$y,lty=2)


###################################################
### chunk number 43: lotkafig
###################################################
require(deSolve)
model <- function (time,VAR,pars)
{
 with (as.list(c(VAR,pars)), {
  #  the rate of change of the state variables
  dx     <- a*x*(1-x/K)-b*x*y
  dy     <- g*b*x*y    - e*y

 return(list(c(dx,dy)))
                     })
}

pars  <- c(a=0.05,b=0.0002,K=500,g=0.8,e=0.03)
VAR   <- c(x=300,y=10)
times <- seq(0,1000,1)

out   <- as.data.frame(lsoda(VAR,times,model,pars))
plot(out$x,out$y,type="l")

VAR   <- c(x=200,y=50)
out2  <- as.data.frame(lsoda(VAR,times,model,pars))
lines(out2$x,out2$y,lty=2)


###################################################
### chunk number 44: lor
###################################################
require(scatterplot3d)
model<-function(t,state,parameters)
  {
  with(as.list(c(state)),{

    dx     <- -8/3*x+y*z
    dy     <- -10*(y-z)
    dz     <- -x*y+28*y-z

    list(c(dx,dy,dz))            })

 }  # end of model

state <-c(x=1, y=1, z=1)
times <-seq(0,100,0.005)
out   <-as.data.frame(lsoda(state,times,model,0))
scatterplot3d(out$x,out$y,out$z,type="l",
        main="Lorenz butterfly",ylab="",grid=FALSE,box=FALSE)


###################################################
### chunk number 45: lorfig
###################################################
require(scatterplot3d)
model<-function(t,state,parameters)
  {
  with(as.list(c(state)),{

    dx     <- -8/3*x+y*z
    dy     <- -10*(y-z)
    dz     <- -x*y+28*y-z

    list(c(dx,dy,dz))            })

 }  # end of model

state <-c(x=1, y=1, z=1)
times <-seq(0,100,0.005)
out   <-as.data.frame(lsoda(state,times,model,0))
scatterplot3d(out$x,out$y,out$z,type="l",
        main="Lorenz butterfly",ylab="",grid=FALSE,box=FALSE)


