###################################################
### chunk number 1: preliminaries
###################################################
library(marelac)
library(marelacTeaching)
options(prompt = ">")
options(width=70)


###################################################
### chunk number 2: 
###################################################
 pi*0.795^2 ; 25*6/sqrt(67) ; log(25)


###################################################
### chunk number 3: 
###################################################
A <- 3 + cos(pi)
    - sqrt(5)


###################################################
### chunk number 4: 
###################################################
A <- 1
B <- 2
A+B


###################################################
### chunk number 5: 
###################################################
V<-factorial(10)


###################################################
### chunk number 6: 
###################################################
V/10


###################################################
### chunk number 7: 
###################################################
 V


###################################################
### chunk number 8: 
###################################################
 (X <- sin(3/2*pi) )


###################################################
### chunk number 9: 
###################################################
c(0, pi/2, pi, 3*pi/2, 2*pi)
seq(from=0,to=2*pi, by=pi/2 )
seq(0, 2*pi, pi/2 )


###################################################
### chunk number 10: 
###################################################
sin( seq(0, 2*pi, pi/2 ))


###################################################
### chunk number 11: 
###################################################
rep(1,times=5)
rep(c(1,2),times=5)
c(rep(1,5),rep(2,5))


###################################################
### chunk number 12: 
###################################################
 V <- 1:20
 sqrt(V)


###################################################
### chunk number 13: 
###################################################
(V <- 0.5:10.5)
6:1


###################################################
### chunk number 14: 
###################################################
V <- vector(length=10)
FF<- vector()


###################################################
### chunk number 15: 
###################################################
(fruit <- c(banana=1, apple=2, orange =3))
names(fruit)


###################################################
### chunk number 16: 
###################################################
A <-matrix(nrow=2,data=c(1,2,3,4))


###################################################
### chunk number 17: 
###################################################
A
sqrt(A)


###################################################
### chunk number 18: 
###################################################
(M <-matrix(nrow=4, ncol=3, byrow=TRUE, data=1:12))


###################################################
### chunk number 19: 
###################################################
diag(1,nrow=2)


###################################################
### chunk number 20: 
###################################################
rownames(A) <- c("x","y")
colnames(A) <- c("c","b")
A


###################################################
### chunk number 21: 
###################################################
V <- 0.5:5.5
rbind(V,sqrt(V))


###################################################
### chunk number 22: 
###################################################
t(A)


###################################################
### chunk number 23: 
###################################################
AR <-array(dim=c(2,3,2),data=1)


###################################################
### chunk number 24: 
###################################################
(V <- seq(-2,2,0.5))
 V>0


###################################################
### chunk number 25: 
###################################################
V [V > 0]


###################################################
### chunk number 26: 
###################################################
V [V > 0] <- 0


###################################################
### chunk number 27: 
###################################################
 sum(V < 0)


###################################################
### chunk number 28: 
###################################################
V [V != 0]


###################################################
### chunk number 29: 
###################################################
V [V<(-1) | V>1]


###################################################
### chunk number 30: 
###################################################
which (V == 0)
which.min (V)


###################################################
### chunk number 31: 
###################################################
genus <- c("Sabatieria","Molgolaimus")
dens  <- c(1,2)
Nematode <-data.frame(genus=genus,density=dens)
Nematode


###################################################
### chunk number 32: 
###################################################
Nematode$density/sum(Nematode$density)


###################################################
### chunk number 33: 
###################################################
mean(Nematode[,2])


###################################################
### chunk number 34: 
###################################################
options(prompt = " ")


###################################################
### chunk number 35: 
###################################################
Circlesurface <- function (radius) pi*radius^2


###################################################
### chunk number 36: 
###################################################
options(prompt = ">")


###################################################
### chunk number 37: 
###################################################
Circlesurface(10)
Circlesurface(1:20)


###################################################
### chunk number 38: 
###################################################
Sphere <- function(radius)
{
 volume  <- 4/3*pi*radius^3
 surface <- 4 *pi*radius^2
 return(list(volume=volume,surface=surface))
}


###################################################
### chunk number 39: 
###################################################
Sphere(6371)


###################################################
### chunk number 40: 
###################################################
Sphere(1:5)$volume


###################################################
### chunk number 41: 
###################################################
Rho_W <- function(T=20)
{
999.842594 + 0.06793952 * T - 0.00909529 * T^2 +
0.0001001685 * T^3 - 1.120083e-06 * T^4 + 6.536332e-09 * T^5
}


###################################################
### chunk number 42: 
###################################################
Rho_W()
Rho_W(20)
Rho_W(0)


###################################################
### chunk number 43: 
###################################################
Dummy <- function (x)
{
if ( x<0  ) string <- "x<0"     else
if ( x<2  ) string <- "0>=x<2"  else
            string <- "x>=2"
print(string)
}


###################################################
### chunk number 44: 
###################################################
Dummy(-1)
Dummy(1)
Dummy(2)


###################################################
### chunk number 45: 
###################################################
x<-2
ifelse (x>0, "positive", "negative,0")


###################################################
### chunk number 46: 
###################################################
for (i in 1:3) print(c(i,2*i,3*i))


###################################################
### chunk number 47: 
###################################################
i<-1 ; while(i<3) {print(i); i<-i+1}


###################################################
### chunk number 48: 
###################################################
i<-1
repeat
{
  print(i)
  i <-i+1
  if(i>2) break
}


###################################################
### chunk number 49: f1
###################################################
a <- seq(0,2*pi, length.out=100)
plot(x=cos(a),y=sin(a))


###################################################
### chunk number 50: f1fig
###################################################
a <- seq(0,2*pi, length.out=100)
plot(x=cos(a),y=sin(a))


###################################################
### chunk number 51: f2g
###################################################
plot(cos(a),sin(a),type="l",lwd=2,xlab="",ylab="",axes=FALSE,
 asp=1)
for (i in seq( 0.1,0.9,by=0.1)) lines(i*sin(a), i*cos(a))
polygon(sin(a)*0.1,cos(a)*0.1,col="red")
for (i in 1:10) text(x=0,y=i/10-0.025,labels=11-i,font=2)
shots1 <- matrix(ncol=2, data=rnorm(n=20,sd=0.2))
shots2 <- matrix(ncol=2, data=rnorm(n=20,sd=0.5))
points(shots1,col="darkblue",pch=16,cex=1.5)
points(shots2,col="darkgreen",pch=16,cex=1.5)
legend("topright",legend=c("A","B"),pch=16,
 col=c("darkblue","darkgreen"),pt.cex=1.5)


###################################################
### chunk number 52: f2fig
###################################################
plot(cos(a),sin(a),type="l",lwd=2,xlab="",ylab="",axes=FALSE,
 asp=1)
for (i in seq( 0.1,0.9,by=0.1)) lines(i*sin(a), i*cos(a))
polygon(sin(a)*0.1,cos(a)*0.1,col="red")
for (i in 1:10) text(x=0,y=i/10-0.025,labels=11-i,font=2)
shots1 <- matrix(ncol=2, data=rnorm(n=20,sd=0.2))
shots2 <- matrix(ncol=2, data=rnorm(n=20,sd=0.5))
points(shots1,col="darkblue",pch=16,cex=1.5)
points(shots2,col="darkgreen",pch=16,cex=1.5)
legend("topright",legend=c("A","B"),pch=16,
 col=c("darkblue","darkgreen"),pt.cex=1.5)


###################################################
### chunk number 53: 
###################################################
head(Orange)
tail(Orange)


###################################################
### chunk number 54: f3
###################################################
plot(Orange$age, Orange$circumference,xlab="age, days",
     ylab="circumference, mm", main= "Orange tree growth")


###################################################
### chunk number 55: f3fig
###################################################
plot(Orange$age, Orange$circumference,xlab="age, days",
     ylab="circumference, mm", main= "Orange tree growth")


###################################################
### chunk number 56: f4
###################################################
plot(Orange$age, Orange$circumference,xlab="age,
   days",ylab="circumference, mm", main= "Orange tree growth",
   pch=(15:20)[Orange$Tree],col=(1:5) [Orange$Tree],cex=1.3)
legend("bottomright",pch=15:20,col=1:5,legend=1:5)


###################################################
### chunk number 57: f4fig
###################################################
plot(Orange$age, Orange$circumference,xlab="age,
   days",ylab="circumference, mm", main= "Orange tree growth",
   pch=(15:20)[Orange$Tree],col=(1:5) [Orange$Tree],cex=1.3)
legend("bottomright",pch=15:20,col=1:5,legend=1:5)


###################################################
### chunk number 58: bat
###################################################
require(marelac)
image(Bathymetry$x,Bathymetry$y,Bathymetry$z,col=femmecol(100),
      asp=TRUE,xlab="",ylab="")
contour(Bathymetry$x,Bathymetry$y,Bathymetry$z,add=TRUE)


###################################################
### chunk number 59: batfig
###################################################
require(marelac)
image(Bathymetry$x,Bathymetry$y,Bathymetry$z,col=femmecol(100),
      asp=TRUE,xlab="",ylab="")
contour(Bathymetry$x,Bathymetry$y,Bathymetry$z,add=TRUE)


###################################################
### chunk number 60: mat
###################################################
curve(sin(3*pi*x))
curve(sin(3*pi*x),from=0,to=2,col="blue",
      xlab="x",ylab="f(x)",main="curve")
curve(cos(3*pi*x),add=TRUE,col="red",lty=2)
abline(h=0,lty=2)
legend("bottomleft",c("sin","cos"),text.col=c("blue","red"),lty=1:2)


###################################################
### chunk number 61: matfig
###################################################
curve(sin(3*pi*x))
curve(sin(3*pi*x),from=0,to=2,col="blue",
      xlab="x",ylab="f(x)",main="curve")
curve(cos(3*pi*x),add=TRUE,col="red",lty=2)
abline(h=0,lty=2)
legend("bottomleft",c("sin","cos"),text.col=c("blue","red"),lty=1:2)


###################################################
### chunk number 62: 
###################################################
(A <-matrix(nrow=2,data=c(1,2,3,4)))
solve(A) %*% A


###################################################
### chunk number 63: 
###################################################
t(A)


###################################################
### chunk number 64: 
###################################################
B <- c(5,6)
solve(A,B)


###################################################
### chunk number 65: 
###################################################
eigen(A)


###################################################
### chunk number 66: 
###################################################
(rr<-uniroot(f = function(x) cos(x)-2*x, interval=c(-10,10)))


###################################################
### chunk number 67: root2
###################################################
curve(cos(x)-2*x,-10,10)
abline(h=0,lty=2)
points(rr$root,0,pch=16,cex=2)


###################################################
### chunk number 68: r1fig
###################################################
curve(cos(x)-2*x,-10,10)
abline(h=0,lty=2)
points(rr$root,0,pch=16,cex=2)


###################################################
### chunk number 69: 
###################################################
require(seacarb)
kc1 <- K1(S=0,T=20,P=0)    # Carbonate k1
kc2 <- K2(S=0,T=20,P=0)    # Carbonate k2

pHfunction <- function(pH, kc1,kc2, DIC, Alkalinity )
{
   H    <- 10^(-pH)
   HCO3 <- H*kc1  /(H*kc1 + H*H + kc1*kc2)*DIC
   CO3  <- kc1*kc2 /(H*kc1 + H*H + kc1*kc2)*DIC

   EstimatedAlk  <- -H *1.e6  + HCO3 + 2*CO3
   return ( EstimatedAlk  - Alkalinity)
}


###################################################
### chunk number 70: 
###################################################
uniroot(pHfunction, interval=c(0, 12), tol=1.e-20, kc1=kc1, kc2=kc2,
        DIC=2100, Alkalinity=2200)


###################################################
### chunk number 71: 
###################################################
x <- 1:10
y <- c(9,8,6,7,5,8,9,6,3,5)


###################################################
### chunk number 72: smooth
###################################################
plot(x,y,pch=16,cex=2,main="interpolation,smoothing")
lines (spline(x,y, n=100),lty=1)
points(approx(x,y, xout=seq(1,10,0.1)),pch=1)
lines (smooth.spline(x,y),lty=2)
legend("bottomleft",lty=c(1,NA,2),pch=c(NA,1,NA),
       legend=c("spline","approx","smooth.spline"))


###################################################
### chunk number 73: smoothfig
###################################################
plot(x,y,pch=16,cex=2,main="interpolation,smoothing")
lines (spline(x,y, n=100),lty=1)
points(approx(x,y, xout=seq(1,10,0.1)),pch=1)
lines (smooth.spline(x,y),lty=2)
legend("bottomleft",lty=c(1,NA,2),pch=c(NA,1,NA),
       legend=c("spline","approx","smooth.spline"))


###################################################
### chunk number 74: 
###################################################
year<- seq(1900,1980,by=10)
pop <- c(76.1,92.4,106.5,123.1,132.6,152.3,180.7,204.9,226.5)


###################################################
### chunk number 75: 
###################################################
fit <- nls(pop~K/(1+(K-N0)/N0*exp(-a*(year-1900))),
           start=list(K=500,N0=76.1,a=0.02))


###################################################
### chunk number 76: 
###################################################
summary(fit)


###################################################
### chunk number 77: 
###################################################
(cc<-coef(fit))


###################################################
### chunk number 78: 
###################################################
ll <- c(0.,1,10,20,40,80,120,160,300,480,700)
pp <- c(0.,1,3,4,6,8,10,11,10,9,8)


###################################################
### chunk number 79: 
###################################################
model <- function(t,state,pars)
{
with (as.list(c(state,pars)),
{
 dA <- r*(x-A)-k*A*B
 dB <- r*(y-B)+k*A*B
 return (list(c(dA,dB)))
 }
     )
}
times <- seq(0,300,1)
state <- c(A=1,B=1)
parms <- c(x =1, y = 0.1, k = 0.05, r = 0.05)
out   <- as.data.frame(ode(state,times,model,parms))


###################################################
### chunk number 80: 
###################################################
head(out)


###################################################
### chunk number 81: ode
###################################################
ylim   <- range(c(out$A,out$B))
plot(out$time,out$A,xlab="time",ylab="concentration",
      lwd=2,type="l",ylim=ylim,main="model")
lines(out$time,out$B,lwd=2,lty=2)
legend("topright",legend=c("A","B"),lwd=2,lty=c(1,2))


###################################################
### chunk number 82: lvfig
###################################################
ylim   <- range(c(out$A,out$B))
plot(out$time,out$A,xlab="time",ylab="concentration",
      lwd=2,type="l",ylim=ylim,main="model")
lines(out$time,out$B,lwd=2,lty=2)
legend("topright",legend=c("A","B"),lwd=2,lty=c(1,2))


###################################################
### chunk number 83: 
###################################################
require(scatterplot3d)
model<-function(t,state,parameters)
  {
  with(as.list(c(state)),{

    dx     <- -8/3*x+y*z
    dy     <- -10*(y-z)
    dz     <- -x*y+28*y-z

    list(c(dx,dy,dz))            })

 }  # end of model

state <-c(x=1, y=1, z=1)
times <-seq(0,100,0.005)
out   <-as.data.frame(lsoda(state,times,model,0))
scatterplot3d(out$x,out$y,out$z,type="l",
        main="Lorenz butterfly",ylab="",grid=FALSE,box=FALSE)


