### Name: marginTree.confusion
### Title: A function giving a table of true versus predicted values, from
###   a margin tree.
### Aliases: marginTree.confusion


### ** Examples

#generate some data with 5 classes and 100 features
set.seed(543)

x=matrix(rnorm(40*1000),nrow=40)
y=sort(rep(1:5,8))
x[y==2 | y==3, 1:50]=x[y==2|y==3, 1:50]+1
x[y==3,51:100]=x[y==3,51:100]+1
x[y==4|y==5,1:50]=x[y==4|y==5,1:50]-1
x[y==5, 51:100]=x[y==5,51:100]+1

#train the classifier

train.obj<-   marginTree(x,y)

# print out confusion matrix 

marginTree.confusion(train.obj, threshold=.5)

# do cross-validation and print out CV confusion matrix
cv.obj<-marginTree.cv(x,y,train.obj)

marginTree.confusion(cv.obj, threshold=.5)



