### Name: marginTree.getnonzero
### Title: Get important features at each split of the margin tree
### Aliases: marginTree.getnonzero


### ** Examples

#generate some data with 5 classes and 100 features
set.seed(543)

x=matrix(rnorm(40*1000),nrow=40)
y=sort(rep(1:5,8))
x[y==2 | y==3, 1:50]=x[y==2|y==3, 1:50]+1
x[y==3,51:100]=x[y==3,51:100]+1
x[y==4|y==5,1:50]=x[y==4|y==5,1:50]-1
x[y==5, 51:100]=x[y==5,51:100]+1

#train the classifier

train.obj<-  marginTree(x,y)

# examine the selected features at each split

junk<- marginTree.getnonzero(train.obj,threshold=.5)

summary(junk)



