### Name: marginTree.predict
### Title: Prediction from the margin tree classifier
### Aliases: marginTree.predict


### ** Examples

#generate some data with 5 classes and 100 features

set.seed(543)
x=matrix(rnorm(40*1000),nrow=40)
y=sort(rep(1:5,8))
x[y==2 | y==3, 1:50]=x[y==2|y==3, 1:50]+1
x[y==3,51:100]=x[y==3,51:100]+1
x[y==4|y==5,1:50]=x[y==4|y==5,1:50]-1
x[y==5, 51:100]=x[y==5,51:100]+1

#generate some test data
xx=x+5*matrix(rnorm(40*1000),nrow=40)
yy=y

#train the classifier

train.obj<-   marginTree(x,y)

# get predictions for test data
marginTree.predict(train.obj,xx)



