###################################################
### chunk number 1: 
###################################################
options(width=72)


###################################################
### chunk number 2: 
###################################################
library(memisc)
options(digits=3)
nes1948.por <- UnZip("anes/NES1948.ZIP","NES1948.POR",package="memisc")


###################################################
### chunk number 3: 
###################################################
nes1948 <- spss.portable.file(nes1948.por)
print(nes1948)


###################################################
### chunk number 4: 
###################################################
names(nes1948)


###################################################
### chunk number 5: 
###################################################
description(nes1948)


###################################################
### chunk number 6:  eval=FALSE
###################################################
## codebook(nes1948)


###################################################
### chunk number 7: 
###################################################
vote.48 <- subset(nes1948,
              select=c(
                  v480018,
                  v480029,
                  v480030,
                  v480045,
                  v480046,
                  v480047,
                  v480048,
                  v480049,
                  v480050
                  ))


###################################################
### chunk number 8: 
###################################################
str(vote.48)


###################################################
### chunk number 9: 
###################################################
vote.48 <- rename(vote.48,
                  v480018 = "vote",
                  v480029 = "occupation.hh",
                  v480030 = "unionized.hh",
                  v480045 = "gender",
                  v480046 = "race",
                  v480047 = "age",
                  v480048 = "education",
                  v480049 = "total.income",
                  v480050 = "religious.pref"
        )


###################################################
### chunk number 10: 
###################################################
codebook(vote.48)


###################################################
### chunk number 11: 
###################################################
vote.48 <- within(vote.48,{
  vote3 <- recode(vote,
    1 -> "Truman",
    2 -> "Dewey",
    3:4 -> "Other"
    )
  occup4 <- recode(occupation.hh,
    10:20 -> "Upper white collar",
    30 -> "Other white collar",
    40:70 -> "Blue collar",
    80 -> "Farmer"
    )
  relig3 <- recode(religious.pref,
    1 -> "Protestant",
    2 -> "Catholic",
    3:5 -> "Other,none"
    )
   race2 <- recode(race,
    1 -> "White",
    2 -> "Black"
    )
  })


###################################################
### chunk number 12: 
###################################################
toLatex(xtabs(~vote3+occup4,data=vote.48))


###################################################
### chunk number 13: 
###################################################
toLatex(t(genTable(percent(vote3)~occup4,data=vote.48)),
  digits=c(1,1,1,0))


###################################################
### chunk number 14: 
###################################################
toLatex(t(genTable(percent(vote3)~relig3,data=vote.48)),
  digits=c(1,1,1,0))


###################################################
### chunk number 15: 
###################################################
toLatex(t(genTable(percent(vote3)~race2,data=vote.48)),
  digits=c(1,1,1,0))


###################################################
### chunk number 16: 
###################################################
inc.tab <- t(genTable(percent(vote3)~total.income,data=vote.48))
rownames(inc.tab) <- gsub("$","\\$",rownames(inc.tab),fixed=TRUE)
toLatex(inc.tab,digits=c(1,1,1,0))


###################################################
### chunk number 17: 
###################################################
options(width=60)


###################################################
### chunk number 18: 
###################################################
agg.inc <- aggregate(percent(vote3,ci=TRUE)~total.income,data=vote.48)
agg.inc.errbars <- xyplot(cbind(Percentage,upper,lower)~total.income,
        data=subset(agg.inc,vote3=="Truman"),
        panel=panel.errbars,
        xlab="Household income",
        ylab="Percentage voting for Truman",
        pch=19,ewidth=0.2,
        scales=list(x=list(
          rot=90
          )),
        )


###################################################
### chunk number 19:  eval=FALSE
###################################################
## print(agg.inc.errbars)


###################################################
### chunk number 20: 
###################################################
trellis.device(pdf,file="agg-inc-errbars.pdf",width=6,height=6)
print(agg.inc.errbars)
dev.off()
trellis.device(postscript,file="agg-inc-errbars.eps",width=6,height=6)
print(agg.inc.errbars)
dev.off()


###################################################
### chunk number 21: 
###################################################
options(width=72)


###################################################
### chunk number 22: 
###################################################
agg.occup <- aggregate(percent(vote3,ci=TRUE)~occup4,data=vote.48)
agg.occup.errbars <- xyplot(cbind(Percentage,upper,lower)~occup4,
        data=subset(agg.occup,vote3=="Truman"),
        panel=panel.errbars,
        xlab="Occupation head of household",
        ylab="Percentage voting for Truman",
        pch=19,ewidth=0.2,
        scales=list(x=list(
          rot=90
          )),
        )


###################################################
### chunk number 23:  eval=FALSE
###################################################
## print(agg.occup.errbars)


###################################################
### chunk number 24: 
###################################################
trellis.device(pdf,file="agg-occup-errbars.pdf",width=6,height=6)
print(agg.occup.errbars)
dev.off()
trellis.device(postscript,file="agg-occup-errbars.eps",width=6,height=6)
print(agg.occup.errbars)
dev.off()


###################################################
### chunk number 25: 
###################################################
vote.48 <- within(vote.48,{
  contrasts(occup4) <- contr("treatment",base = 3)
  contrasts(total.income) <- contr("treatment",base = 4)
  })


###################################################
### chunk number 26: 
###################################################
model1 <- glm((vote3=="Truman")~occup4,data=vote.48,
              family="binomial")
model2 <- glm((vote3=="Truman")~total.income,data=vote.48,
              family="binomial")
model3 <- glm((vote3=="Truman")~occup4+total.income,data=vote.48,
              family="binomial")
model4 <- glm((vote3=="Truman")~relig3,data=vote.48,
              family="binomial")
model5 <- glm((vote3=="Truman")~occup4+relig3,data=vote.48,
              family="binomial")


###################################################
### chunk number 27: 
###################################################
mtable(model1,model2,model3,summary.stats=c("Nagelkerke R-sq.","Deviance","AIC","N"))


###################################################
### chunk number 28: 
###################################################
toLatex(relabel(mtable(
            "Model 1"=model1,
            "Model 2"=model2,
            "Model 3"=model3,
            summary.stats=c("Nagelkerke R-sq.","Deviance","AIC","N")),
          "[(]Intercept[)]"="\\\\emph{Intercept}",
          "[$]"="\\\\$",
          UNDER="under",
          "AND OVER"="and over",
          occup4="Occup. class",
          total.income="Income",
          gsub=TRUE
          ),
          ddigits=5
        )


###################################################
### chunk number 29: 
###################################################
toLatex(relabel(mtable(
              "Model 1"=model1,
              "Model 4"=model4,
              "Model 5"=model5,
              summary.stats=c("Nagelkerke R-sq.","Deviance","AIC","N")),
          "[(]Intercept[)]"="\\\\emph{Intercept}",
            occup4="Occup. class",
            relig3="Religion",
            gsub=TRUE
            ),
          ddigits=5)


###################################################
### chunk number 30: 
###################################################
Tp35 <- Termplot(model3,model5,se=TRUE,residuals="none",xrot=90)#,models="columns")


###################################################
### chunk number 31:  eval=FALSE
###################################################
## print(Tp35)


###################################################
### chunk number 32: 
###################################################
trellis.device(pdf,file="Tp35.pdf",width=7,height=7)
print(Tp35)
dev.off()
trellis.device(postscript,file="Tp35.eps",width=7,height=7)
print(Tp35)
dev.off()


