### Name: aggragate.formula
### Title: Data Frames and Tables of Descriptive Statistics
### Aliases: aggregate.formula genTable fapply fapply.default
### Keywords: misc

### ** Examples

ex.data <- expand.grid(mu=c(0,100),sigma=c(1,10))[rep(1:4,rep(100,4)),]
ex.data <- within(ex.data,
                  x<-rnorm(
                    n=nrow(ex.data),
                    mean=mu,
                    sd=sigma
                    )
                  )

aggregate(~mu+sigma,data=ex.data)
aggregate(mean(x)~mu+sigma,data=ex.data)
aggregate(mean(x)~mu+sigma,data=ex.data,name="Average")
aggregate(c(mean(x),sd(x))~mu+sigma,data=ex.data)
aggregate(c(Mean=mean(x),StDev=sd(x),N=length(x))~mu+sigma,data=ex.data)
genTable(c(Mean=mean(x),StDev=sd(x),N=length(x))~mu+sigma,data=ex.data)

aggregate(table(Admit)~.,data=UCBAdmissions)
aggregate(Table(Admit,Freq)~.,data=UCBAdmissions)
aggregate(Admit~.,data=UCBAdmissions)
aggregate(percent(Admit)~.,data=UCBAdmissions)
aggregate(percent(Admit)~Gender,data=UCBAdmissions)
aggregate(percent(Admit)~Dept,data=UCBAdmissions)
aggregate(percent(Gender)~Dept,data=UCBAdmissions)
aggregate(percent(Admit)~Dept,data=UCBAdmissions,Gender=="Female")
genTable(percent(Admit)~Dept,data=UCBAdmissions,Gender=="Female")



