### Name: bucket
### Title: Abstract Data Structures to Collect Simulation Results
### Aliases: bucket default_bucket put_into put_into.default_bucket
###   dim.default_bucket as.data.frame.default_bucket
###   as.matrix.default_bucket as.data.frame.default_bucket print.bucket
###   pour_out pour_out.default_bucket textfile_bucket
###   put_into.textfile_bucket pour_out.textfile_bucket dim.textfile_bucket
###   as.data.frame.textfile_bucket as.matrix.textfile_bucket [.bucket


### ** Examples

Normal.example <- function(mean=0,sd=1,n=10){
  x <- rnorm(n=n,mean=mean,sd=sd)
  c(
    Mean=mean(x),
    Median=median(x),
    Var=var(x)
  )
}

Sim_default_bucket <- Simulate(
    Normal.example(mean,sd,n),
    expand.grid(
          mean=0,
          sd=c(1,10),
          n=c(10,100)
          ),
    nsim=200)


tempfile_bucket <- function(n)textfile_bucket(n,name=tempfile())

Sim_textfile_bucket <- Simulate(
    Normal.example(mean,sd,n),
    expand.grid(
          mean=0,
          sd=c(1,10),
          n=c(10,100)
          ),
    nsim=200,
    bucket=tempfile_bucket
    )

Sim_default_bucket
Sim_default_bucket[1:10]

Sim_textfile_bucket
Sim_textfile_bucket[1:10]

# Access of the textfile generated by 'textfile_bucket':
Sim_textfile_bucket$name
read.table(Sim_textfile_bucket$name,header=TRUE,nrow=10)




