### Name: panel.errbars
### Title: Panel Functions for Error Bars
### Aliases: panel.errbars
### Keywords: hplot

### ** Examples

library(lattice)
library(grid)
## Don't show: 
if(interactive())
  old.prompt <- grid::grid.prompt(TRUE)
## End Don't show

applications <- aggregate(percent(Dept,weight=Freq,ci=TRUE)~Gender,
                                      data=UCBAdmissions)
admissions <- aggregate(
        percent(Admit=="Admitted",weight=Freq,ci=TRUE)~Dept+Gender,
                                      data=UCBAdmissions)
xyplot(cbind(Percentage,lower,upper)~Gender|Dept,data=admissions,
      panel=panel.errbars,
      ewidth=.2,pch=19,
      ylab="Percentage applicants admitted by Department")
xyplot(cbind(Percentage,lower,upper)~Gender|Dept,data=applications,
      panel=panel.errbars,
      ewidth=.2,pch=19,
      ylab="Percentage applications to the Department")

## Don't show: 
if(interactive())
  grid::grid.prompt(old.prompt)
## End Don't show




