### Name: prediction.frame
### Title: Produce a Data Frame of Predictions and Independent Variables
### Aliases: prediction.frame prediction.frame.default
### Keywords: datagen

### ** Examples

lm1 <- lm(sr ~ pop15 + pop75 + dpi + ddpi, data = LifeCycleSavings)
lm2 <- lm(sr ~ pop15 + pop75 + dpi + ddpi + pop15*dpi, data = LifeCycleSavings)

str(prediction.frame(lm1))
str(prediction.frame(lm1, se.fit=TRUE))
str(prediction.frame(lm1, interval="prediction"))
str(prediction.frame(lm1, type="terms"))
str(prediction.frame(lm1,
                  se.fit=TRUE,
                  type="terms"))

str(prediction.frame(lm1,
                  se.fit=TRUE,
                  type="terms",
                  residuals="working"))

str(prediction.frame(lm1,
                  se.fit=TRUE,
                  type="terms",
                  residuals="deviance"))

str(prediction.frame(lm2,
                  se.fit=TRUE,
                  type="terms",
                  residuals="standardized"))

berkeley <- aggregate(Table(Admit,Freq)~.,data=UCBAdmissions)
berk2 <- glm(cbind(Admitted,Rejected)~Gender+Dept,data=berkeley,family="binomial")

str(prediction.frame(berk2,
                  se.fit=TRUE,
                  type="terms",
                  residuals="studentized"))



