### Name: Simulate
### Title: Simulation Experiments
### Aliases: Simulate interrupt
### Keywords: misc

### ** Examples

Normal.example <- function(mean=0,sd=1,n=10){
  x <- rnorm(n=n,mean=mean,sd=sd)
  c(
    Mean=mean(x),
    Median=median(x),
    Var=var(x)
  )
}

Normal.simres <- Simulate(
    Normal.example(mean,sd,n),
    expand.grid(
          mean=0,
          sd=c(1,10),
          n=c(10,100)
          ),
    nsim=200,
    trace=50)

genTable(sd(Median)~sd+n,data=Normal.simres)

expr.simres <- Simulate(
      median(rnorm(n,mean,sd)),
      expand.grid(
          n=c(10,100),
          mean=c(0,1),
          sd=c(1,10)
      ),
    nsim=200,
    trace=50
    )

genTable(c(mean(result),sd(result))~sd+n+mean,data=expr.simres)

## Not run: 
##D ## This takes a little bit longer
##D lm.example <- function(a=0,b=1,n=101,xrange=c(-1,1),serr=1){
##D   x <- seq(from=xrange[1],to=xrange[2],length=n)
##D   y <- a + b*x + rnorm(n,sd=serr)
##D   lm.res <- lm(y~x)
##D   coef <- lm.res$coef
##D   names(coef) <- c("a","b")
##D   coef
##D }
##D 
##D lm.simres <- Simulate(
##D       lm.example(n=n,serr=serr),
##D       expand.grid(
##D       serr=c(0.1,1,10),
##D       n=c(11,101,501)
##D       ),
##D       nsim=200,
##D       trace=50
##D     )
##D genTable(c(sd(a),sd(b))~serr+n,data=lm.simres)
## End(Not run)






