calc.RL.0              package:mixstock              R Documentation

_U_s_e _R_a_f_t_e_r_y _a_n_d _L_e_w_i_s _d_i_a_g_n_o_s_t_i_c_s _t_o _c_a_l_c_u_l_a_t_e _M_C_M_C _c_h_a_i_n _l_e_n_g_t_h_s

_D_e_s_c_r_i_p_t_i_o_n:

     Uses 'coda::raftery.diag' (the Raftery and Lewis diagnostic) to
     estimate minimum chain lengths for an MCMC estimate for mixed
     stock analysis. Runs R&L iteratively until the criteria are
     satisfied.

_U_s_a_g_e:

     calc.RL.0(data, startfval, pilot=500, maxit=15, verbose=FALSE,
     rseed=1001, debug=FALSE)
     calc.mult.RL(data,n=50,debug=FALSE,verbose=FALSE)
     RL.max(r)

_A_r_g_u_m_e_n_t_s:

    data: a 'mixstock.data' object, or any list with 'sourcesamp' and
          'mixsamp' entries containing source  and mixed stock data

startfval: starting value of contribution frequencies for the chain, as
          in 'gibbs' or 'gibbsC': NULL=random start, 0=equal
          contributions from all sources, (1..R-1)=95% contribution
          from one source, with the rest splitting the remainder
          equally

   pilot: Chain length to start with (length of "pilot" run)

   maxit: Max. number of iterations of the Raftery and Lewis procedure

 verbose: Produce lots of output?

   rseed: Random-number seed

   debug: produce debugging output?

       n: number of different random-number seed chains to try

       r: the results of a Raftery and Lewis diagnostic test

_D_e_t_a_i_l_s:

     'calc.RL.00' starts by running a Gibbs-sampler chain with the
     length given by 'pilot', then repeatedly lengthens the chain until
     the length is greater than that suggested as the total by the
     Raftery and Lewis diagnostic.  (The next suggested step in the
     procedure is to run multiple chains of this length and see whether
     they pass the Gelman and Rubin diagnostic.) 'calc.mult.RL' runs
     the Raftery and Lewis calculation multiple times, starting each
     chain from a large contribution from each source in turn, to see
     if some starting configurations are slower to converge or if there
     is a lot of variation among chains with different random number
     seeds. 'RL.max' picks the expected maximum chain length given a
     set of diagnostics; 'RL.burn' returns the predicted burn-in
     required.

_V_a_l_u_e:

     for 'calc.RL.00': 

 current: Results of the Raftery and Lewis test on the current
          iteration

 history: History of the iterations:

     for 'calc.mult.RL', a matrix giving the maximum expected chain
     length for each random-number seed/starting point combination

_A_u_t_h_o_r(_s):

     Ben Bolker

_E_x_a_m_p_l_e_s:

     data(bolten98)
     b98c <- markfreq.condense(as.mixstock.data(bolten98))

