mixstock.boot            package:mixstock            R Documentation

_B_o_o_t_s_t_r_a_p _s_a_m_p_l_e_s _o_f _m_i_x_e_d _s_t_o_c_k _a_n_a_l_y_s_i_s _d_a_t_a

_D_e_s_c_r_i_p_t_i_o_n:

     Create a bootstrap (multinomial) sample from a given set of 
     marker data (source and mixed population genotypes), either
     parametric or non-parametric

_U_s_a_g_e:

     mixstock.boot(x, param=FALSE, condense=TRUE,save.freq=FALSE,
     param.match="mean")

_A_r_g_u_m_e_n_t_s:

       x: "Standard" mixstock data, a list with 'mixsamp' (vector of
          samples in the mixed population) and 'sourcesamp' (matrix of
          samples in the sources, rows=markers, columns=sources)

   param: parametric bootstrapping or not?

condense: use 'markfreq.condense' on the results?

save.freq: save frequencies?

param.match: match mean or mode of distribution when parametric
          bootstrapping?

_D_e_t_a_i_l_s:

     Nonparametric bootstrapping just resamples the observed data from
     the mixed population and from each source with replacement; this
     is equivalent to taking a multinomial sample with the
     probabilities equal to the observed sample frequencies. 
     Parametric bootstrapping takes the observed samples and resamples
     the probabilities themselves from a Dirichlet distribution, then
     takes a multinomial sample.

_V_a_l_u_e:

     A bootstrapped data set, in the same format as the input data:
     i.e., 

 mixsamp: samples in mixed population

sourcesamp: samples in sources

     ...

_A_u_t_h_o_r(_s):

     Ben Bolker

_E_x_a_m_p_l_e_s:

     true.freq <- matrix(c(0.65,0.33,0.01,0.01,
                            0.33,0.65,0.01,0.01),ncol=2)
     true.contrib <- c(0.9,0.1)
     x <- simmixstock0(true.freq,true.contrib,50,100,1004)
     nboot <- 1000
     boot.results.par <- matrix(NA,ncol=12,nrow=nboot)
     boot.results.npar <- matrix(NA,ncol=12,nrow=nboot)
     for (i in 1:nboot) {
       x.par  <- mixstock.boot(x,param=TRUE,condense=FALSE)
       x.npar <- mixstock.boot(x,condense=FALSE)
       boot.results.par[i,] <- c(x.par$sourcesamp,x.par$mixsamp)
       boot.results.npar[i,] <- c(x.npar$sourcesamp,x.npar$mixsamp)
     }
     summary(boot.results.par[,7:8])
     summary(boot.results.npar[,7:8])
     par(mfrow=c(1,2))
     hist(boot.results.par[,7])
     hist(boot.results.npar[,7])

