q.to.p               package:mixstock               R Documentation

_R_e_a_l-_t_o-_m_u_l_t_i_f_r_e_q_u_e_n_c_y _t_r_a_n_s_f_o_r_m_a_t_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     Transform a vector of n real-valued variables in (-Inf,Inf) [or
     (0,1)] to a vector of n+1 variables in (0,1) that sum to 1, or
     vice versa.

_U_s_a_g_e:

     q.to.p(q, transf="full")
     p.to.q(p, transf="full")

_A_r_g_u_m_e_n_t_s:

       q: Unconstrained/transformed values: vector of n numeric values
          in (-Inf,Inf) [if 'transf="full"'] or (0,1) [if
          'transf="part"']

       p: Vector of n+1 numeric values in (0,1) that sum to 1

  transf: (character) "full": use arctan transform to transform
          (-Inf,Inf) to (0,1) or vice versa; "part": don't; "none"; no
          transform

_D_e_t_a_i_l_s:

     Essentially, this is a transformation from an unconstrained set of
     variables to a bounded, constrained set of variables.  If contin
     is TRUE, an arctan transformation ('v <-> atan(v)/pi+0.5') is used
     to transform (-Inf,Inf) to (0,1) or vice versa.  In either case,
     the correlated set of variables (which sum to 1) is transformed to
     an unconstrained set by taking each variable to be a remainder:
     'x[1]=x[1]', 'x[2]=x[2]/(1-x[1])', and so forth.

_V_a_l_u_e:

     Vector of transformed values.

_N_o_t_e:

     This transformation is designed to deal with the problems of
     bounded optimization and constraints.  It actually behaves quite
     badly because small values are transformed to large negative
     values, messing up the uniform scaling of the parameters.  Now
     that the bounded optimization of 'optim' has improved,
     'contin="full"' may not be a good idea.  It's not clear whether
     the other transformation (remainders) is better or worse than just
     optimizing on the first (n-1) components and assuming that the
     last frequency equals one minus the sum of the rest.

_A_u_t_h_o_r(_s):

     Ben Bolker

_E_x_a_m_p_l_e_s:

       p.to.q(c(0.3,0.3,0.4))
       p.to.q(c(0.3,0.3,0.4),transf="part")
       q.to.p(c(-4,3))
       q.to.p(c(0,0))
       q.to.p(c(0.5,0.5),transf="part")

