### Name: genboot
### Title: Generate bootstrap estimates of mixed stock analyses
### Aliases: genboot
### Keywords: misc

### ** Examples

  data(simex)
  x <- genboot(simex,method="cml",nboot=100)
  r <- x$resample
  r.ok <- r[!is.na(r[,"Convergence"]) & r[,"Convergence"]==0,]
  old.par <- par(no.readonly=TRUE)
  par(mfrow=c(2,2))
  hist(r.ok[,1],main="Contrib. A")
  hist(r.ok[,2],main="Contrib. B")
  hist(r.ok[,3],main="Neg. log likelihoods")
  plot(r.ok[,1],r.ok[,3],
        xlab="Contrib. A",ylab="NLL")
  par(old.par)



