### Name: mixstock.boot
### Title: Bootstrap samples of mixed stock analysis data
### Aliases: mixstock.boot
### Keywords: misc

### ** Examples

true.freq <- matrix(c(0.65,0.33,0.01,0.01,
                       0.33,0.65,0.01,0.01),ncol=2)
true.contrib <- c(0.9,0.1)
x <- simmixstock0(true.freq,true.contrib,50,100,1004)
nboot <- 1000
boot.results.par <- matrix(NA,ncol=12,nrow=nboot)
boot.results.npar <- matrix(NA,ncol=12,nrow=nboot)
for (i in 1:nboot) {
  x.par  <- mixstock.boot(x,param=TRUE,condense=FALSE)
  x.npar <- mixstock.boot(x,condense=FALSE)
  boot.results.par[i,] <- c(x.par$sourcesamp,x.par$mixsamp)
  boot.results.npar[i,] <- c(x.npar$sourcesamp,x.npar$mixsamp)
}
summary(boot.results.par[,7:8])
summary(boot.results.npar[,7:8])
par(mfrow=c(1,2))
hist(boot.results.par[,7])
hist(boot.results.npar[,7])



