###################################################
### chunk number 1: 
###################################################
Rver <- paste(R.version$major,R.version$minor,sep=".")


###################################################
### chunk number 2:  eval=FALSE
###################################################
## install.packages("mixstock")
## install.packages("plotrix")
## install.packages("coda")
## install.packages("abind")
## install.packages("R2WinBUGS")


###################################################
### chunk number 3: 
###################################################
library(mixstock)


###################################################
### chunk number 4:  eval=FALSE
###################################################
## mydata = read.table("mydata.dat")


###################################################
### chunk number 5:  eval=FALSE
###################################################
## mydata = read.csv("mydata.csv")


###################################################
### chunk number 6: 
###################################################
data(lahanas98raw)
mydata = lahanas98raw


###################################################
### chunk number 7:  eval=FALSE
###################################################
## mydata


###################################################
### chunk number 8: 
###################################################
head(mydata)


###################################################
### chunk number 9: 
###################################################
mydata = as.mixstock.data(mydata)


###################################################
### chunk number 10: 
###################################################
plot(mydata,mix.off=2)


###################################################
### chunk number 11: 
###################################################
mydata = markfreq.condense(mydata)


###################################################
### chunk number 12: 
###################################################
data(lahanas98)


###################################################
### chunk number 13: 
###################################################
data(bolten98)


###################################################
### chunk number 14: 
###################################################
plot(lahanas98,mix.off=2,leg.space=0.4)


###################################################
### chunk number 15: 
###################################################
mydata.cml = cml(mydata)
mydata.cml


###################################################
### chunk number 16:  eval=FALSE
###################################################
## plot(mydata.cml)


###################################################
### chunk number 17: 
###################################################
plot(mydata.cml)


###################################################
### chunk number 18: 
###################################################
mydata.uml = uml(mydata)


###################################################
### chunk number 19:  eval=FALSE
###################################################
## par(ask=TRUE)
## plot(mydata.uml,plot.freqs=TRUE)
## par(ask=FALSE)


###################################################
### chunk number 20:  eval=FALSE
###################################################
## mydata.umlboot = genboot(mydata,"uml")


###################################################
### chunk number 21: 
###################################################
if (!file.exists("umlboot.RData")) {
  t1 <- system.time(mydata.umlboot <- genboot(mydata,"uml"))
  save("t1","mydata.umlboot",file="umlboot.RData",compress=TRUE)
} else load("umlboot.RData")


###################################################
### chunk number 22: 
###################################################
confint(mydata.umlboot)


###################################################
### chunk number 23: 
###################################################
plot(mydata.umlboot)


###################################################
### chunk number 24:  eval=FALSE
###################################################
## mydata.mcmc = tmcmc(mydata)


###################################################
### chunk number 25: 
###################################################
if (!file.exists("mcmc.RData")) {
  mydata.mcmc <- tmcmc(mydata)
  save("mydata.mcmc",file="mcmc.RData",compress=TRUE)
} else load("mcmc.RData")


###################################################
### chunk number 26: 
###################################################
mydata.mcmc
confint(mydata.mcmc)


###################################################
### chunk number 27:  eval=FALSE
###################################################
## plot(mydata.mcmc)


###################################################
### chunk number 28: 
###################################################
plot(mydata.mcmc)


###################################################
### chunk number 29:  eval=FALSE
###################################################
## diag1=calc.RL.0(mydata)


###################################################
### chunk number 30: 
###################################################
if (!file.exists("RL.RData")) {
  diag1=calc.RL.0(mydata)
  save("diag1",file="RL.RData")
} else load("RL.RData")


###################################################
### chunk number 31: 
###################################################
head(diag1$current)


###################################################
### chunk number 32: 
###################################################
diag1$history


###################################################
### chunk number 33:  eval=FALSE
###################################################
## diag2=calc.GR(mydata)


###################################################
### chunk number 34: 
###################################################
if (!file.exists("GR.RData")) {
  diag2=calc.GR(mydata)
  save("diag2",file="GR.RData")
} else load("GR.RData")


###################################################
### chunk number 35: 
###################################################
Z = simmixstock2(nsource=4,nmark=5,nmix=3,
                 sourcesize=c(4,2,1,1),
                 sourcesampsize=rep(25,4),
                 mixsampsize=rep(30,3),rseed=1001)               
Z
plot(Z)


###################################################
### chunk number 36:  eval=FALSE
###################################################
## ## hope this isn't necessary any more?
## ## causes warnings on CRAN
## if (.Platform$OS.type=="unix") {
##   WINE = system("locate wine | grep bin/wine$", intern = TRUE)[2]
##   Sys.setenv(WINE=WINE)
##   Sys.setenv(WINE="/home/ben/cxoffice/bin/wine") ## mine
## }


###################################################
### chunk number 37: 
###################################################
if (!file.exists("wbugs_cache.RData")) {
  st0 <- system.time(Zfit0 <- mm.wbugs(Z,sourcesize=c(4,2,1,1),returntype="bugs"))
  st1 <- system.time(Zfit <- mm.wbugs(Z,sourcesize=c(4,2,1,1)))
  st2 <- system.time(Zfit2 <- mm.wbugs(Z,sourcesize=c(4,2,1,1),bugs.code="BB"))
  save("st0","st1","st2","Zfit","Zfit2","Zfit0",file="wbugs_cache.RData")
} else load("wbugs_cache.RData")


###################################################
### chunk number 38:  eval=FALSE
###################################################
## ## tests
## st3 <- system.time(Zfit0 <- mm.wbugs(Z,sourcesize=c(4,2,1,1),
##                                      bugs.code="BB",pkg="JAGS"))
## Zfit2 <- mm.wbugs(Z,sourcesize=c(4,2,1,1),bugs.code="BB",n.iter=200)
## Zfit3 <- mm.wbugs(Z,sourcesize=c(4,2,1,1),bugs.code="BB",n.iter=1000,pkg="JAGS")


###################################################
### chunk number 39:  eval=FALSE
###################################################
## Zfit0 = mm.wbugs(Z,sourcesize=c(4,2,1,1),returntype="bugs")


###################################################
### chunk number 40:  eval=FALSE
###################################################
## plot(Zfit0)


###################################################
### chunk number 41: 
###################################################
plot(as.mcmc.bugs(Zfit0))


###################################################
### chunk number 42: 
###################################################
print(plot(Zfit))


###################################################
### chunk number 43: 
###################################################
print(plot(Zfit,sourcectr=TRUE))


###################################################
### chunk number 44: 
###################################################
head(summary(Zfit))


###################################################
### chunk number 45:  eval=FALSE
###################################################
## bbcontrib = "http://www.zoo.ufl.edu/bolker/R/windows"
## install.packages("mixstock",contriburl=bbcontrib)
## install.packages("plotrix")
## install.packages("coda")
## install.packages("abind")
## install.packages("R2WinBUGS")


###################################################
### chunk number 46:  eval=FALSE
###################################################
## mydata = hapfreq.condense(as.mixstock.data(read.csv("myfile.dat")))


###################################################
### chunk number 47:  eval=FALSE
###################################################
## mydata.mcmc = tmcmc(mydata)
## mydata.mcmc
## intervals(mydata.mcmc)
## plot(mydata.mcmc)


