### Name: tvar
### Title: Expand Time-varying covariates in models
### Aliases: tvar
### Keywords: models

### ** Examples


nan <- 30
ns <- 5
time.occ <- as.factor(paste("T",1:ns, sep=""))
attr(time.occ,"nan") <- nan
time.mat <- tvar(time.occ, drop=ns) # Last occasion is the reference, the SAS and MARK default.

dim(time.mat) <- c(nan,ns,length(levels(time.occ))-1)
print(time.mat)  # each page is the 2-d matrix used in the fit.
print(time.mat[1,,])

#  compare the above to 
tvar( 1:ns, nan )




