lines.cjs                package:mra                R Documentation

_l_i_n_e_s._c_j_s

_D_e_s_c_r_i_p_t_i_o_n:

     Add a line to an existing CJS capture-recapture plot showing
     either N or survival estimates.

_U_s_a_g_e:

      
     ## S3 method for class 'cjs':
     lines( x, what="n", animals=-1, occasions=-1, ... )

_A_r_g_u_m_e_n_t_s:

       x: CJS object from 'F.cr.estim' 

    what: Indicator for what to plot.  what = "n" plots estimates of
          size (i.e,. $n.hat).  what = "s" plots estimates of survival. 

 animals: Index of animals to plot.  This is the row number for 
          animals to include.  E.g., if 'animals = c(1,4,10)', the 1st,
          4th, and 10th animals represented in the 1st, 4th, and 10th
          rows of the capture history matrix are plotted.  Applies to
          survival estimates only. 

occasions: Sampling occasions to plot.  This must match the occasions
          argument to  the last 'plot.cjs'.  If the first element of
          'occasions' is $<=q$ 0,  all occasions are plotted. 
          Otherwise, only occasions listed in 'occasions' are plotted.

     ...: Additional arguments to 'lines' (for N estimates) or
          'matlines' (for survival  estimates).  Arguments like 'col='
          and 'lty=' may prove useful.

_D_e_t_a_i_l_s:

     This is a utility function for plotting.  Lines are added to the
     current plot.   A current plot must be displayed.

_V_a_l_u_e:

     Nothing.  A value of 1 is invisibly returned.

_A_u_t_h_o_r(_s):

     Trent McDonald, WEST Inc., tmcdonald@west-inc.com

_S_e_e _A_l_s_o:

     'plot.cjs', 'lines', 'matlines'

_E_x_a_m_p_l_e_s:

     data(dipper.histories)
     xy <- F.cjs.covars( nrow(dipper.histories), ncol(dipper.histories) )
     for(j in 1:ncol(dipper.histories)){ assign(paste("x",j,sep=""), xy$x[,,j]) } 
     dipper.cjs <- F.cjs.estim( ~1, ~x2+x3, dipper.histories )  # constant capture probability, period (i.e., flood) effects on survival

     plot(dipper.cjs, type="s", animals=1)
     lines(dipper.cjs, what="s", animals=c(4, 10))

