plot.cjs                 package:mra                 R Documentation

_P_l_o_t _C_J_S _M_o_d_e_l

_D_e_s_c_r_i_p_t_i_o_n:

     Plot the population size or survival estimates for a
     Cormack-Jolly-Seber  model estimated by F.cjs.estim

_U_s_a_g_e:

     ## S3 method for class 'cjs':
     plot(x, type="n", ci = TRUE, smooth = TRUE, occasions = -1, 
             animals = -1, smubass = 5, ...)

_A_r_g_u_m_e_n_t_s:

       x: An object of class 'cjs'.  Objects of this  class are
          estimated open population Cormack-Jolly-Seber models produced
          by F.cjs.estim.

    type: Type of estimates to plot.  type = "n" (the default) produces
           a plot of population size estimates versus capture occasion.
           type = "s" produces a plot of survival estimates versus
          capture occasion.  

      ci: Plot confidence intervals? If ci=TRUE, confidence intervals 
          around population size or survival estimates are plotted
          (depending on 'type='), otherwise, only  confidence intervals
          are not ploted.

  smooth: Smooth estimates of population size? If type="n", smooth=TRUE
          will produce  a smoothed (supsmu) line through plotted size
          estimates. Ignored for type="s". 

occasions: Vector of occasion numbers to use in plot. If any(occasions
          <= 0),  all occasions are plotted.  Otherwise, plot the
          occasions specified. For example,  if occasions = c(1,3,5),
          only estimates from the 1st, 3rd, and 5th capture  occasion
          are plotted.  If type = "n", occasion = 1 (1st occasion)
          cannot  be plotted because it can't be estimated.  If type =
          "s", occasion = ncol(y)  (last occasion) cannot  be plotted
          because no survival interval exist beyond the end of the
          study.

 animals: Vector of individuals to plot.  This parameter is used only
          when plotting survival estimates.  For example, animals =
          c(1,2,10) plots the  survival estimates of the 1st, 2nd, and
          10th animals (rows 1, 2, and 10 of the survival  estimate
          matrix).

 smubass: Bass parameter for super-smoothed line, if called for by
          smooth=TRUE.  Must be between 0 and 10.  Larger numbers
          produce smoother lines.

     ...: Additional arguments to 'plot' (for size estimates) or
          'matplot' (for  survival estimates). Options such as ylim=,
          col=, cex.axis=, etc. may be useful. 

_D_e_t_a_i_l_s:

     Confidence intervals on survival estimates cannot be plotted with
     this routine. To plot confidence intervals surrounding survival
     estimates, call this routine with type="s", then compute 
     confidence intervals for survival estimates, and use 'lines' to
     add lines to the plot.

_V_a_l_u_e:

     For type="s", the survival estimate matrix that was plotted is  is
     invisibly returned.  For type = "n", the smooth fit is invisibly
     returned if called for  by smooth = TRUE, otherwise NA is
     invisibly returned if smooth = FALSE.

_A_u_t_h_o_r(_s):

     Trent McDonald, WEST-INC, tmcdonald@west-inc.com

_S_e_e _A_l_s_o:

     'F.cjs.estim', 'matplot', 'lines', 'plot'

_E_x_a_m_p_l_e_s:

      

     data(dipper.histories)
     xy <- F.cjs.covars( nrow(dipper.histories), ncol(dipper.histories) )
     for(j in 1:ncol(dipper.histories)){ assign(paste("x",j,sep=""), xy$x[,,j]) }
     dipper.cjs <- F.cjs.estim( ~x2+x3+x4+x5+x6, ~x1+x2+x3+x4+x5, dipper.histories )
     plot(dipper.cjs)
     print(dipper.cjs$s.hat)
     plot(dipper.cjs, type="s", animals=1)

      

