predict.cjs               package:mra               R Documentation

_p_r_e_d_i_c_t._c_j_s

_D_e_s_c_r_i_p_t_i_o_n:

     Predictor method for CJS capture-recapture objects.  Return
     expected  values for all active cells in the model.

_U_s_a_g_e:

     ## S3 method for class 'cjs':
     predict(object, ...)

_A_r_g_u_m_e_n_t_s:

  object: CJS capture-recapture model as output from F.cjs.estim 

     ...: Additional arguments to other functions.  Not used, but must
          be here  for compatability with the generic 'predict'
          function. 

_D_e_t_a_i_l_s:

     The only components of 'cjsobj' needed are '$histories', '$p.hat',
     '$s.hat'

_V_a_l_u_e:

     A nan X ns matrix of fitted values (=cell expected value), where 
     nan=number of animals and ns=number of samples.  Fitted values in
     the  non-active cells are set to NA.  Non-active  cells are those
     prior to and including the initial capture, and after  the
     occasion on which an animal is known to have died.  Computation of
      expected values is described in the 'details' section of the help
     file  for 'F.cjs.gof'.

_A_u_t_h_o_r(_s):

     Trent McDonald, WEST Inc., tmcdonald@west-inc.com

_S_e_e _A_l_s_o:

     'F.cjs.estim', 'F.cjs.gof'

_E_x_a_m_p_l_e_s:

     # Fit CJS model to dipper data, time-varying capture and survivals.
     data(dipper.histories)
     xy <- F.cjs.covars( nrow(dipper.histories), ncol(dipper.histories) )
     for(j in 1:ncol(dipper.histories)){ assign(paste("x",j,sep=""), xy$x[,,j]) } # Extract 2-D matricies of 0s and 1s
     dipper.cjs <- F.cjs.estim( ~x2+x3+x4+x5+x6, ~x1+x2+x3+x4+x5, dipper.histories )
     dipper.expected <- predict(dipper.cjs)

