print.cjs                package:mra                R Documentation

_P_r_i_n_t _C_o_r_m_a_c_k-_J_o_l_l_y-_S_e_b_e_r (_C_J_S) _M_o_d_e_l_s

_D_e_s_c_r_i_p_t_i_o_n:

     Print method for Cormack-Jolly-Seber (CJS) models estimated by
     F.cjs.estim().

_U_s_a_g_e:

     ## S3 method for class 'cjs':
     print(x, alpha=c(0.05,0.01), ...)

_A_r_g_u_m_e_n_t_s:

       x: An object of class "cjs" produced by F.cjs.estim()

   alpha: A vector with length either 2 or 3 containing alpha levels 
          used to put "*" or "**" beside the GOF results.  One * is
          printed if significance is between alpha[1] and alpha[2] 
          (i.e., if alpha[2] < p < alpha[1]).  Two ** are printed if
          significance  is less than alpha[2] (p < alpha[2]). 

     ...: Arguments to other functions called by this one. Currently no
          other  functions are called, so this is not used, but must be
          here  for compatability with the generic 'print' function. 

_V_a_l_u_e:

     Nothing is returned.  This function is used exclusively for its
     side effects.  It prints an object of class "cjs" in a nice
     human-readable format.  If goodness-of-fit tests are present, 
     they are printed.  If population size estimates are present, they
     are printed.

_A_u_t_h_o_r(_s):

     Trent McDonald, Ph.D., WEST-INC, tmcdonald@west-inc.com

_S_e_e _A_l_s_o:

     'F.cjs.estim', 'plot.cjs'

_E_x_a_m_p_l_e_s:

      

     # Fit CJS model to dipper data, time-varying capture and survivals.
     data(dipper.histories)
     xy <- F.cjs.covars( nrow(dipper.histories), ncol(dipper.histories) )
     for(j in 1:ncol(dipper.histories)){ assign(paste("x",j,sep=""), xy$x[,,j]) } 
     dipper.cjs <- F.cjs.estim( ~x2+x3+x4+x5+x6, ~x1+x2+x3+x4+x5, dipper.histories )
     print(dipper.cjs)

      

