residuals.cjs              package:mra              R Documentation

_R_e_s_i_d_u_a_l_s _f_o_r _C_J_S _M_o_d_e_l

_D_e_s_c_r_i_p_t_i_o_n:

     Residual extraction routine for a CJS object. Returns Pearson or
     deviance residuals  of a CJS capture-recapture model.

_U_s_a_g_e:

     ## S3 method for class 'cjs':
     residuals(object, type="pearson", ...)

_A_r_g_u_m_e_n_t_s:

  object: a CJS (Cormack-Jolly-Seber capture-recapture) object, which
          is usually  the result of calling F.cjs.estim  

    type: string indicating type of residual to return.  Either
          "pearson" for Pearson residuals (i.e., (o - e)/sqrt(e*(1-e)))
          or "deviance" for deviance  residuals (i.e.,
          2*sign(o-e)*sqrt{o*log(o/e) + (1-o)*log((1-o)/(1-e))} ) 

     ...: Additional arguments to other functions. Not used, but must
          be here  for compatability with the generic 'residuals'
          function. 

_D_e_t_a_i_l_s:

     In almost all cases, a CJS model fitted by F.cjs.estim already has
     a '$residuals' component.  This  routine either extracts this
     component, or computes residuals of the component if not found.

     Observed component (o(ij)) in formulas above is the capture
     indicator for animal i during occasion j.  If animal i  was seen
     during occasion j, o(ij) = 1.  Otherwise, o(ij) = 0.

     Expected component (e(ij)) in formula above is the expected value
     of the capture indicator for animal  i during occasion j.  In
     other words, o(ij) is a binomial random variable with expected 
     value e(ij).  Under the assumptions of a CJS model, e(ij) is
     computed as  phi(i(1)) * phi(i(2)) * ... * phi(i(j-1)) * p(ij),
     where  p(ij) is the estimated capture probability of animal i
     during occasion j, and phi(i(1)) is estimated survival during the
     first interval  following initial capture of the animal, phi(i(2))
     is survival during the second interval  after initial capture, 
     and phi(i(j-1)) is survival during the interval just prior to
     occasion j.

_V_a_l_u_e:

     A NAN X NS matrix of residuals, where NAN = number of animals and
     NS = number of capture occasions.  Residuals in the non-active
     cells are set to NA.  Non-active  cells are those prior to and
     including the initial capture, and after  the occasion on which an
     animal is known to have died.

     If type = "pearson", the residual for active cell (i,j) is  (o(ij)
     - e(ij)) / sqrt(e(ij) * (1 - e(ij))). 

     If type = "deviance", the residual for active cell (i,j) is  2 *
     sign(o(ij) - e(ij)) * sqrt(o(ij)*log(o(ij) / e(ij)) + (1 - o(ij))
     * log((1 - o(ij)) / (1 - e(ij)))). 

     Observed (o(ij)) and expected (e(ij)) are defined in Details.

_A_u_t_h_o_r(_s):

     Trent McDonald

_S_e_e _A_l_s_o:

     'F.cjs.estim', 'predict.cjs'

_E_x_a_m_p_l_e_s:

     # Fit CJS model to dipper data, time-varying capture and survivals.
     data(dipper.histories)
     xy <- F.cjs.covars( nrow(dipper.histories), ncol(dipper.histories) )
     for(j in 1:ncol(dipper.histories)){ assign(paste("x",j,sep=""), xy$x[,,j]) } 
     dipper.cjs <- F.cjs.estim( ~x2+x3+x4+x5+x6, ~x1+x2+x3+x4+x5, dipper.histories )
     residuals(dipper.cjs)

