### Name: sci.ratio.gen
### Title: Simultaneous confidence intervals for ratios of coefficients in
###   the general linear model
### Aliases: sci.ratio.gen
### Keywords: htest

### ** Examples


################################################

# Slope-ratio assay on data from Jensen(1989),
# Biometrical Journal 31, 841-853.

# Definition of the vector of responses and
# the design matrix can be done directly as
# follows:

Y0 <- scan()
1.3 1.7 2.4 2.7 3.6 3.6 4.7 5.0 6.1 6.3

Y1 <- scan()
2.8 2.9 4.1 3.7 5.5 5.5 6.4 6.7

Y2 <- scan()
2.2 2.1 3.2 3.2 3.8 3.9 4.7 4.9

Y3 <- scan()
2.3 2.3 3.2 3.0 4.2 4.2 4.6 5.1
 
Y <- c(Y0,Y1,Y2,Y3) # the response vector

xi <- rep(1,34)
x0 <- c(0,0, gl(4,2),rep(0,8*3))
x1 <- c(rep(0,10),gl(4,2), rep(0,8*2))
x2 <- c(rep(0,18),gl(4,2), rep(0,8))
x3 <- c(rep(0,26),gl(4,2))

X <- cbind(xi,x0,x1,x2,x3) # the design matrix

# Have a look at the response vector:
Y

# and the design matrix:

X

# In this problem, interest is simultaneous estimation of
# the ratios of slopes relative to the slope of the standard
# treatment. Therefore, the appropriate contrast matrices are:

Num.Contrast <- matrix(c(0,0,1,0,0,
                         0,0,0,1,0,
                         0,0,0,0,1),nrow=3,byrow=TRUE)
Den.Contrast <- matrix(c(0,1,0,0,0,
                         0,1,0,0,0,
                         0,1,0,0,0),nrow=3,byrow=TRUE)


SlopeRatioCI <- sci.ratio.gen(Y=Y, X=X,
 Num.Contrast=Num.Contrast, Den.Contrast=Den.Contrast)

SlopeRatioCI

# Further details of the fitted model and the contrasts used:

summary(SlopeRatioCI)

plot(SlopeRatioCI)

#########################################################

# If one starts with a dataframe, the function model.matrix
# can be used to create the design matrix:

data(SRAssay)
SRAssay

# Create the design matrix using model.matrix

X <- model.matrix(Response~Treatment:Dose, data=SRAssay)
Response <- SRAssay[,"Response"]

# The response vector and the design matrix are now:

X
Response

# The following coefficients result from fitting this model:

lm(Response~0+X)

# The same contrasts as above are used:

Num.Contrast <- matrix(c(0,0,1,0,0,
                         0,0,0,1,0,
                         0,0,0,0,1),nrow=3,byrow=TRUE)
Den.Contrast <- matrix(c(0,1,0,0,0,
                         0,1,0,0,0,
                         0,1,0,0,0),nrow=3,byrow=TRUE)

summary(sci.ratio.gen(Y=Response, X=X, Num.Contrast, Den.Contrast))




