### Name: sci.ratioVH
### Title: Approximate simultaneous confidence intervals for ratios of
###   means when variances are heterogeneous
### Aliases: sci.ratioVH
### Keywords: htest

### ** Examples


data(Mutagenicity, package="mratios")

boxplot(MN~Treatment, data=Mutagenicity)

# Unless it is hard to assume Gaussian distribution
# in this example this is an attempt to take
# heterogeneous variances into account.

# Comparisons to the vehicle control,
# Proof of Hazard, using multiplicity adjusted 
# confidence intervals:

sci.ratioVH(MN~Treatment, data=Mutagenicity,
 type="Dunnett", base=6, method="Plug")

# Unadjusted confidence intervals for an 
# intersection union test to proof safety
# for all doses of the compound.

sci.ratioVH(MN~Treatment, data=Mutagenicity,
 type="Dunnett", base=6, method="Unadj", alternative="less")

# # # # 

# User-defined contrasts:

# Mutagenicity of the doses of the new compound,
# expressed as ratio (DoseX-Vehicle)/(Cyclo25-Vehicle):

# Check the order of the factor levels:

levels(Mutagenicity$Treatment)

# numerators:

NC<-rbind(
"Hydro30-Vehicle"=c(0,0,1,0,0,-1),
"Hydro50-Vehicle"=c(0,0,0,1,0,-1),
"Hydro75-Vehicle"=c(0,0,0,0,1,-1),
"Hydro100-Vehicle"=c(0,1,0,0,0,-1)
)

DC<-rbind(
"Cyclo25-Vehicle"=c(1,0,0,0,0,-1),
"Cyclo25-Vehicle"=c(1,0,0,0,0,-1),
"Cyclo25-Vehicle"=c(1,0,0,0,0,-1),
"Cyclo25-Vehicle"=c(1,0,0,0,0,-1)
)

colnames(NC)<-colnames(DC)<-levels(Mutagenicity$Treatment)

NC

DC

CIs<-sci.ratioVH(MN~Treatment, data=Mutagenicity,
 Num.Contrast=NC,
 Den.Contrast=DC)

# # # #

# Unadjusted confidence intervals for multiple ratios
# of means assuming heterogeneous group variances.
# The following code produces the results given in Table
# V of Hasler, Vonk and Hothorn (2007).
# The upper confidence limits in Table V can produced
# by calling:

sci.ratioVH(formula=MN~Treatment, data=Mutagenicity,
 Num.Contrast=NC, Den.Contrast=DC,
 method="Unadj", alternative="less", conf.level=0.95)




