### Name: simtest.ratio
### Title: Simultaneous tests for ratios of normal means
### Aliases: simtest.ratio simtest.ratioI
### Keywords: htest

### ** Examples


library(mratios)

########################################################

# User-defined contrasts for comparisons
# between Active control, Placebo and three dosage groups:

data(AP)
AP
boxplot(prepost~treatment, data=AP)

# Test whether the differences of doses 50, 100, 150 vs. Placebo
# are non-inferior to the difference of Active control vs. Placebo 

# User-defined contrasts:

# Numerator Contrasts:

NC <- rbind(
"(D100-D0)" = c(0,-1,1,0,0),
"(D150-D0)" = c(0,-1,0,1,0),
 "(D50-D0)" = c(0,-1,0,0,1))

# Denominator Contrasts:

DC <- rbind(
"(AC-D0)" = c(1,-1,0,0,0),
"(AC-D0)" = c(1,-1,0,0,0),
"(AC-D0)" = c(1,-1,0,0,0))

NC
DC

noninf <- simtest.ratio(prepost ~ treatment, data=AP,
 Num.Contrast=NC, Den.Contrast=DC, Margin.vec=c(0.9,0.9,0.9),
 alternative="greater")

summary( noninf )

#########################################################

# Some more examples on standard multiple comparison procedures
# stated in terms of ratio hypotheses:

# Comparisons vs. Control:

many21 <- simtest.ratio(prepost ~ treatment, data=AP,
 type="Dunnett")

summary(many21)

# Let the Placebo be the control group, which is the second level
# in alpha-numeric order. A simultaneous test for superiority of
# the three doses and the Active control vs. Placebo could be
# done as: 

many21P <- simtest.ratio(prepost ~ treatment, data=AP,
 type="Dunnett", base=2, alternative="greater", Margin.vec=1.1)
summary(many21P)

# All pairwise comparisons:

allpairs <- simtest.ratio(prepost ~ treatment, data=AP,
 type="Tukey")

summary(allpairs)

#######################################################

# Comparison to grand mean of all strains
# in the Penicillin example:

data(Penicillin)

CGM <- simtest.ratio(diameter~strain, data=Penicillin, type="GrandMean")
CGM
summary(CGM)




