### Name: t.test.ratio
### Title: t-test for the ratio of two means
### Aliases: t.test.ratio t.test.ratio.default t.test.ratio.formula
### Keywords: htest

### ** Examples


library(mratios)

####################################################

# ASAT values of female rats in a toxicity study
#     (Hauschke, 1999).

data(ASAT)
ASAT

t.test.ratio(ASAT~group, data=ASAT, alternative="less",
 base=1, rho=1.25, var.equal=TRUE)

######################################################

# Bodyweights of male rats in a toxicity study.
# Objective was to show equivalence between the high
# dose group (Dosis) and the control group (Kon).
# Equivalence margins are set to 0.8 and 1.25. The 
# type-I-error to show equivalence is set to alpha=0.05.

data(rat.weight)

# two one-sided tests:

t.test.ratio(weight~group, data=rat.weight, alternative="less",
 rho=1.25, var.equal=TRUE)

t.test.ratio(weight~group, data=rat.weight, alternative="greater",
 rho=0.8, var.equal=TRUE)


# For rho=1, t.test.ratio corresponds to a simple t.test
# with the difference of means under the null set to zero 
# (,i.e. mu=0).

t.test.ratio(ASAT~group, data=ASAT, alternative="less",
 rho=1, var.equal=TRUE)

t.test(ASAT~group, data=ASAT, alternative="less",
 mu=0, var.equal=TRUE)




