### Name: ep
### Title: Correlated Binary Data
### Aliases: ep
### Keywords: datagen distribution multivariate

### ** Examples


# Create mean vector
mu=c(0.5, 0.3, 0.20, 0.1)

# Create correlation matrix
R = c(
    1    , 0.2 , 0.15, -0.05,
    0.2  , 1   , 0.25, 0.2  , 
    0.15 , 0.25, 1   , 0.25 ,
    -0.05, 0.2 , 0.25, 1
)
R = matrix(R, ncol=4)

ep0 = ep(mu=mu, R=R, nRep=1000, seed=NULL)
apply(ep0$y, 2, mean); cor(ep0$y)

#Generates more responses based on the parameters provided above.
ep1 = ep(isd = ep0$isd, nRep=1000, seed=NULL)
apply(ep1$y, 2, mean); cor(ep1$y)

# 5-variate based on common mean and exchangeable correlation.
ep2 = ep(mu=0.3, rho=0.2, n=5, nRep=10000)
apply(ep2$y, 2, mean); cor(ep2$y)




