### Name: plot.nlreg.contours
### Title: Use plot() on a `nlreg.contours' object
### Aliases: plot.nlreg.contours
### Keywords: methods hplot regression nonlinear

### ** Examples

data(metsulfuron)
metsulfuron.nl <- 
    nlreg( formula = log(area) ~ log( b1+(b2-b1) / (1+(dose/b4)^b3) ), 
           weights = ~ ( 1+dose^exp(g) )^2, data = metsulfuron, 
           start = c(b1 = 138, b2 = 2470, b3 = 2, b4 = 0.07, g = log(0.3)),
           hoa = TRUE )
##
metsulfuron.prof <- profile( metsulfuron.nl, trace = TRUE )
metsulfuron.cont <- contour( metsulfuron.prof, ret = TRUE, plotit = FALSE )
par( mai = rep(0.2, 4) )
plot( metsulfuron.cont )



