### Name: profile.nlreg
### Title: Profile Method for `nlreg' Objects
### Aliases: profile.nlreg
### Keywords: regression nonlinear methods

### ** Examples

data(metsulfuron)
metsulfuron.nl <- 
    nlreg( formula = log(area) ~ log( b1+(b2-b1) / (1+(dose/b4)^b3) ), 
           weights = ~ ( 1+dose^exp(g) )^2, data = metsulfuron, 
           start = c(b1 = 138, b2 = 2470, b3 = 2, b4 = 0.07, g = log(0.3)),
           hoa = TRUE )
##
metsulfuron.prof <- profile( metsulfuron.nl, offset = g, trace = TRUE )
plot( metsulfuron.prof, lwd2 = 2 )
#
metsulfuron.prof <- profile( metsulfuron.nl, trace = TRUE )
plot( metsulfuron.prof, nframe = c(2,3), lwd2 = 2 )



