summary.mpl              package:nlreg              R Documentation

_S_u_m_m_a_r_y _M_e_t_h_o_d _f_o_r _m_p_l _O_b_j_e_c_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Returns a summary list for objects of class 'mpl'.

_U_s_a_g_e:

     ## S3 method for class 'mpl':
     summary(object, correlation = FALSE, digits = NULL, ...)

_A_r_g_u_m_e_n_t_s:

  object: a fitted 'mpl' object, that is, the result of a call to 
          'mpl.nlreg'.  

correlation: logical argument.  If 'TRUE', the (asymptotic) correlation
           matrix for the  parameter estimates is computed; default is
          'FALSE'. 

  digits: the number of significant digits to be printed.  Defaults to 
          'NULL'.  

     ...: absorbs any additional argument. 

_D_e_t_a_i_l_s:

     This function is a method for the generic function  'summary' for
     class 'mpl'. It can be invoked by calling 'summary' for an  object
     of the appropriate class, or directly by calling  'summary.mpl'
     regardless of the class of the object.

_V_a_l_u_e:

     A list is returned with the following components: 

  varPar: the maximum adjusted profile likelihood estimates of the
          variance parameters.  

coefficients: the constrained MLEs of the regression coefficients 
          given the maximum adjusted profile likelihood estimates of
          the  variance parameters.  

  offset: the values passed through the 'offset' argument in the call 
          to 'mpl.nlreg' that generated the 'mpl'  object and to which
          the variance parameters were fixed. 

varParMLE: the MLEs of the variance parameters. 

 coefMLE: the MLEs of the regression coefficients. 

varParCov: the (asymptotic) covariance matrix of the variance
          parameters,  that is, the corresponding block in the inverse
          of the observed  information matrix. 

 coefCov: the (asymptotic) covariance matrix of the regression
          coefficients, that is, the corresponding block in the inverse
          of the observed  information matrix. 

     lmp: the adjusted profile log likelihood from the fit.  

      lp: the profile log likelihood from the fit.  

   stats: the indicator of which higher order solution was used. 

 formula: the model formula. 

 meanFun: the formula expression of the mean function. 

  varFun: the formula expression of the variance function. 

    data: a list representing a summary of the original data with the 
          following components.

          ''_o_f_f_s_e_t _n_a_m_e'' the predictor variable with no duplicated
               value.

          '_r_e_p_l' the number of replicates available for each value of
               the  predictor.

          '_d_u_p_l' a vector of the same length than the predictor
               variable  indicating the position of each data point in
               the  _offset name_ component.

          '_t_1' the sum of the reponses for each design point in the
               _offset name_ component. 

          '_t_2' the sum of the squared responses for each design point
               in  the _offset name_ component. 


    nobs: the number of observations. 

    iter: the number of interations needed for convergence; only if 
          'offset' was not 'NULL' in the call to  'mpl.nlreg' which
          generated 'object'. 

    call: an image of the call to 'mpl.nlreg', but with  all the
          arguments explicitly named. 

      ws: the workspace component of the original  'nlreg object' plus
          the following  components:

          '_c_o_r_r' a logical value indicating whether the correlation
               matrix should be printed.

          '_d_i_g_i_t_s' the number of significant digits to be printed.


_S_e_e _A_l_s_o:

     'mpl.object', 'nlreg.object', 'summary'

_E_x_a_m_p_l_e_s:

     data(metsulfuron)
     metsulfuron.nl <- 
         nlreg( formula = log(area) ~ log( b1+(b2-b1) / (1+(dose/b4)^b3) ), 
                weights = ~ ( 1+dose^exp(g) )^2, data = metsulfuron, hoa = TRUE, 
                start = c(b1 = 138, b2 = 2470, b3 = 2, b4 = 0.07, g = log(0.3)) )
     ##
     metsulfuron.mpl <- mpl( metsulfuron.nl, trace = TRUE )
     summary( metsulfuron.mpl, corr = FALSE )

