summary.nlreg.profile         package:nlreg         R Documentation

_S_u_m_m_a_r_y _M_e_t_h_o_d _f_o_r _O_b_j_e_c_t_s _o_f _C_l_a_s_s _n_l_r_e_g._p_r_o_f_i_l_e

_D_e_s_c_r_i_p_t_i_o_n:

     Returns a summary list for objects of class 'nlreg.profile'.

_U_s_a_g_e:

     ## S3 method for class 'nlreg.profile':
     summary(object, alpha = 0.05, twoside = TRUE, digits = NULL, ...)

_A_r_g_u_m_e_n_t_s:

  object: a 'nlreg.profile' object, that is, the result of a call to 
          'profile.nlreg'. 

   alpha: a vector of levels for confidence intervals; the default is 
          1-'alpha'=0.95. 

 twoside: a logical value.  If 'TRUE', two-sided confidence intervals
          are returned.  The default is 'TRUE'. 

  digits: the number of significant digits to be printed. 

     ...: absorbs any additional argument. 

_D_e_t_a_i_l_s:

     This function is a method for the generic function  'summary' for
     objects of class  'nlreg.profile'.  It can be invoked by calling
     'summary'  or directly 'summary.nlreg.profile' for an object of
     the appropriate class.

_V_a_l_u_e:

     A list is returned with the following components: 

      CI: a matrix with k*dim('alpha') rows  and 2 columns, where k
          equals 2 or 4 depending on whether 'hoa = TRUE' in the call
          that generated 'object'.  This matrix contains the upper and
          lower confidence bounds for the  considered test statistics
          and for the confidence levels specified through 'alpha'. 

inf.sk, np.sk, inf.fr, np.fr: the information and nuisance parameters
          aspects, that is, the two  terms into which the higher order
          adjustment leading to the  r* statistic can be decomposed. 
          The two versions refer  to respectively Skovgaard's (1996)
          proposal and Fraser,  Reid and Wu's (1999) solution.  Only if
           'hoa = TRUE' in the function call that generated the 
          'nlreg.profile' object argument 'object'. 

     mle: a numerical vector giving the MLE of the parameter of 
          interest and its standard error. 

  offset: character string giving the name of the interest parameter. 

 twoside: a logical value indicating whether two-sided or one-sided 
          confidence intervals were calculated. 

  points: the number of output points at which the considered
          statistics were calculated exactly. 

       n: the approximate number of points used in the spline
          interpolation  of the considered statistics. 

     hoa: a logical value indicating whether higher order solutions
          were calculated. 

  digits: the number of significant digits to be printed. 

    call: an image of the call that produced the object, but with all 
          arguments named. 

     ...: absorbs additional arguments. 

_R_e_f_e_r_e_n_c_e_s:

     Fraser, D.A.S., Reid, N. and Wu, J. (1999).  A simple general
     formula  for tail probabilities for frequentist and Bayesian
     inference.  _Biometrika_, *86*, 249-264.

     Skovgaard, I.  (1996) An explicit large-deviation approximation to
     one-parameter tests.  _Bernoulli_, *2*, 145-165.

_S_e_e _A_l_s_o:

     'nlreg.profile.object', 'profile.nlreg', 'summary'

_E_x_a_m_p_l_e_s:

     data(metsulfuron)
     metsulfuron.nl <- 
         nlreg( formula = log(area) ~ log( b1+(b2-b1) / (1+(dose/b4)^b3) ), 
                weights = ~ ( 1+dose^exp(g) )^2, data = metsulfuron, 
                start = c(b1 = 138, b2 = 2470, b3 = 2, b4 = 0.07, g = log(0.3)),
                hoa = TRUE )
     ##
     metsulfuron.prof <- profile( metsulfuron.nl, offset = g, trace = TRUE )
     summary( metsulfuron.prof, alpha = c(0.9, 0.95) )

