###################################################
### chunk number 1: 
###################################################
library(nsRFA)


###################################################
### chunk number 2: 
###################################################
Nsim=1000
n=60


###################################################
### chunk number 3: 
###################################################
campsimulati <- rnorm(n*Nsim)


###################################################
### chunk number 4: a
###################################################
campsimulati <- matrix(campsimulati, ncol=n)


###################################################
### chunk number 5: b
###################################################
lmom <- t(apply(campsimulati, 1, Lmoments))
vlmom <- t(apply(campsimulati, 1, varLmoments, matrix=FALSE))

l3 <- lmom[,"lca"]*lmom[,"l2"]
sl3 <- sqrt(vlmom[,"var.l3"])


###################################################
### chunk number 6: 
###################################################
l3gaussian <- l3/sl3


###################################################
### chunk number 7: 
###################################################
qqnorm(l3gaussian, main="Normal Q-Q Plot for Gaussian samples")
 qqline(l3gaussian)


###################################################
### chunk number 8: 
###################################################
campsimulati <- rt(n*Nsim, df=5)


###################################################
### chunk number 9: 
###################################################
campsimulati <- matrix(campsimulati, ncol=n)
lmom <- t(apply(campsimulati, 1, Lmoments))
vlmom <- t(apply(campsimulati, 1, varLmoments, matrix=FALSE))

l3 <- lmom[,"lca"]*lmom[,"l2"]
sl3 <- sqrt(vlmom[,"var.l3"])


###################################################
### chunk number 10: 
###################################################
l3student <- l3/sl3


###################################################
### chunk number 11: 
###################################################
campsimulati <- rcauchy(n*Nsim)


###################################################
### chunk number 12: 
###################################################
campsimulati <- matrix(campsimulati, ncol=n)
lmom <- t(apply(campsimulati, 1, Lmoments))
vlmom <- t(apply(campsimulati, 1, varLmoments, matrix=FALSE))

l3 <- lmom[,"lca"]*lmom[,"l2"]
sl3 <- sqrt(vlmom[,"var.l3"])


###################################################
### chunk number 13: 
###################################################
l3cauchy <- l3/sl3


###################################################
### chunk number 14: 
###################################################
campsimulati <- runif(n*Nsim)


###################################################
### chunk number 15: 
###################################################
campsimulati <- matrix(campsimulati, ncol=n)
lmom <- t(apply(campsimulati, 1, Lmoments))
vlmom <- t(apply(campsimulati, 1, varLmoments, matrix=FALSE))

l3 <- lmom[,"lca"]*lmom[,"l2"]
sl3 <- sqrt(vlmom[,"var.l3"])


###################################################
### chunk number 16: 
###################################################
l3unif <- l3/sl3


###################################################
### chunk number 17: 
###################################################
#bitmap(file="Fig1.png", type="png256", height=10, width=8, res=144, pointsize=16)
png(filename="Fig1.png", height=720, width=600, res=72, pointsize=16)


###################################################
### chunk number 18: 
###################################################
layout(matrix(c(1,2,3,4), 2, 2, byrow = TRUE))
qqnorm(l3gaussian, main="Normal Plot: Gaussian samples")
 qqline(l3gaussian)
qqnorm(l3student, main="Normal Plot: Student (df=5) samples")
 qqline(l3student)
qqnorm(l3cauchy, main="Normal Plot: Cauchy samples")
 qqline(l3cauchy)
qqnorm(l3unif, main="Normal Plot: Uniform samples")
 qqline(l3unif)


###################################################
### chunk number 19: 
###################################################
dev.off()


